/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiMyDraftsForm;
import org.exoplatform.wiki.webui.bean.DraftBean;
import org.exoplatform.wiki.webui.bean.WikiDraftListAccess;
import org.exoplatform.wiki.webui.commons.UIWikiDraftGrid;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiMyDraftsForm.gtmpl", events={@EventConfig(listeners={DeleteDraftActionListener.class}, confirm="UIWikiMyDraftsForm.msg.delete-confirm"), @EventConfig(listeners={ResumeDraftActionListener.class}), @EventConfig(listeners={ViewDraftChangeActionListener.class}), @EventConfig(listeners={SortDraftActionListener.class})})
public class UIWikiMyDraftsForm
extends UIForm {
    public static final int ITEMS_PER_PAGE = 20;
    public static final String DRAFT_GRID = "UIWikiDraftGrid";
    public static final String DRAFT_ITER = "DraftIter";
    public static final String ACTION_DELETE = "DeleteDraft";
    public static final String ACTION_RESUME = "ResumeDraft";
    public static final String ACTION_VIEW = "ViewDraftChange";
    public static final String ACTION_SORT = "SortDraft";
    public static final String[] DRAFT_FIELD = new String[]{"pageTitle", "place", "lastEdition"};
    public static final String[] USER_ACTIONS = new String[]{"ViewDraftChange", "DeleteDraft"};

    public UIWikiMyDraftsForm() throws Exception {
        UIWikiDraftGrid grid = (UIWikiDraftGrid)this.addChild(UIWikiDraftGrid.class, null, DRAFT_GRID);
        grid.getUIPageIterator().setId(DRAFT_ITER);
        grid.getUIPageIterator().setParent((UIComponent)this);
        grid.configure("id", DRAFT_FIELD, USER_ACTIONS);
        grid.setActionForField("pageTitle", ACTION_RESUME);
        grid.setFieldToDisplayBreadCrumb("place");
        this.initGrid();
    }

    public void initGrid() throws Exception {
        if ("__anonim".equals(org.exoplatform.wiki.utils.Utils.getCurrentUser())) {
            return;
        }
        WikiService wService = (WikiService)PortalContainer.getComponent(WikiService.class);
        List drafts = wService.getDrafts(org.exoplatform.wiki.utils.Utils.getCurrentUser());
        ArrayList<DraftBean> draftBeans = new ArrayList<DraftBean>();
        UIWikiDraftGrid grid = (UIWikiDraftGrid)this.getChild(UIWikiDraftGrid.class);
        grid.clearBreadcrum();
        ResourceBundle bundle = RequestContext.getCurrentInstance().getApplicationResourceBundle();
        String newPageHint = bundle.getString("UIWikiMyDraftsForm.title.new-page");
        for (DraftPage draftPage : drafts) {
            Page pageImpl;
            if (draftPage.getTargetPage() == null || (pageImpl = wService.getPageByUUID(draftPage.getTargetPage())) == null) continue;
            List breadcrumbDatas = wService.getBreadcumb(pageImpl.getWiki().getType(), pageImpl.getWiki().getOwner(), pageImpl.getName());
            grid.putBreadCrumbDatas(draftPage.getName(), breadcrumbDatas);
            String draftTitle = draftPage.getTitle();
            if (draftPage.isNewPage()) {
                draftTitle = draftTitle + newPageHint;
            }
            draftBeans.add(new DraftBean(draftPage.getName(), draftTitle, grid.getWikiName(draftPage.getName()), draftPage.getUpdatedDate()));
        }
        if (grid.getSortField() == null) {
            grid.setSortField("lastEdition");
            grid.setASC(false);
        }
        this.sortDraft(draftBeans, grid.getSortField(), grid.isASC());
        LazyPageList lazylist = new LazyPageList((ListAccess)new WikiDraftListAccess(draftBeans), 20);
        grid.getUIPageIterator().setPageList((PageList)lazylist);
    }

    private void sortDraft(List<DraftBean> drafts, String field, boolean isASC) {
        if (field == null) {
            return;
        }
        if ("pageTitle".equals(field)) {
            Collections.sort(drafts, new /* Unavailable Anonymous Inner Class!! */);
        } else if ("place".equals(field)) {
            Collections.sort(drafts, new /* Unavailable Anonymous Inner Class!! */);
        } else if ("lastEdition".equals(field)) {
            Collections.sort(drafts, new /* Unavailable Anonymous Inner Class!! */);
        }
        if (!isASC) {
            Collections.reverse(drafts);
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    protected String getActionLink(String action, String beanId) throws Exception {
        UIWikiDraftGrid grid = (UIWikiDraftGrid)this.getChild(UIWikiDraftGrid.class);
        return Utils.createFormActionLink((UIComponent)grid, (String)action, (String)beanId);
    }
}

