/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.Arrays;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.core.UIWikiComponent;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiPageNotFound.gtmpl")
public class UIWikiPageNotFound
extends UIWikiComponent {
    private Log log = ExoLogger.getLogger(this.getClass());
    private WikiService wservice;

    public UIWikiPageNotFound() throws Exception {
        this.accept_Modes = Arrays.asList(WikiMode.PAGE_NOT_FOUND);
        this.wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
    }

    protected Page getRelatedPage() {
        try {
            WikiPageParams params = Utils.getCurrentWikiPageParams();
            return this.wservice.getRelatedPage(params.getType(), params.getOwner(), params.getPageId());
        }
        catch (Exception e) {
            this.log.debug((Object)"Failed to get related page", (Throwable)e);
            return null;
        }
    }

    protected String getHomeURL(WikiPageParams param) throws Exception {
        param.setPageId("WikiHome");
        return Utils.getURLFromParams((WikiPageParams)param);
    }
}

