/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.webui.UIWikiSearchBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiSearchBox.gtmpl", events={@EventConfig(listeners={AdvancedSearchActionListener.class})})
public class UIWikiSearchBox
extends UIForm {
    private static final String FIELD_SEARCHVALUE = "wikiSearchValue";
    private static final String KEYWORD = "keyword";
    private static final String WIKITYPE = "wikiType";
    private static final String WIKIOWNER = "wikiOwner";
    protected String wikiOwner;
    protected String wikiType;

    public UIWikiSearchBox() throws Exception {
        if (this.getId() == null) {
            this.setId("UIWikiSearchBox");
        }
        UIFormStringInput stringInput = new UIFormStringInput(FIELD_SEARCHVALUE, FIELD_SEARCHVALUE, null);
        stringInput.setHTMLAttribute("title", this.getLabel("Search"));
        this.addUIFormInput((UIFormInput)stringInput);
    }

    protected String getContextSearchURL() throws Exception {
        StringBuilder sb = new StringBuilder();
        WikiPageParams currentParams = Utils.getCurrentWikiPageParams();
        String wikiType = currentParams.getType();
        String wikiOwner = currentParams.getOwner();
        sb.append("/").append(PortalContainer.getCurrentPortalContainerName()).append("/").append(PortalContainer.getCurrentRestContextName()).append("/wiki/contextsearch?").append(WIKITYPE).append("=").append(wikiType).append("&").append(WIKIOWNER).append("=").append(wikiOwner).append("&").append(KEYWORD).append("=");
        return sb.toString();
    }
}

