/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.core.api.wiki.Preferences;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.core.UISyntaxSelectBoxFactory;

public class UIWikiSyntaxPreferences
extends UIFormInputSet {
    public static final String FIELD_SYNTAX = "DefaultSyntax";
    public static final String FIELD_ALLOW = "AllowChooseOthers";

    public UIWikiSyntaxPreferences(String id) throws Exception {
        this.setId(id);
        UIFormSelectBox selectSyntax = UISyntaxSelectBoxFactory.newInstance((String)FIELD_SYNTAX, (String)FIELD_SYNTAX);
        this.addChild((UIComponent)selectSyntax);
        UIFormCheckBoxInput allowSelect = new UIFormCheckBoxInput(FIELD_ALLOW, FIELD_ALLOW, null);
        this.addUIFormInput((UIFormInput)allowSelect);
        this.updateData();
    }

    public void updateData() throws Exception {
        WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
        Preferences currentPreferences = Utils.getCurrentPreferences();
        String currentDefaultSyntaxt = currentPreferences.getPreferencesSyntax().getDefaultSyntax();
        if (currentDefaultSyntaxt == null) {
            currentDefaultSyntaxt = wservice.getDefaultWikiSyntaxId();
        }
        UIFormSelectBox selectSyntax = this.getUIFormSelectBox(FIELD_SYNTAX);
        selectSyntax.setValue(currentDefaultSyntaxt);
        UIFormCheckBoxInput allowSelect = this.getUIFormCheckBoxInput(FIELD_ALLOW);
        boolean currentAllow = currentPreferences.getPreferencesSyntax().getAllowMutipleSyntaxes();
        allowSelect.setChecked(currentAllow);
    }
}

