/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.Arrays;
import java.util.ResourceBundle;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.webui.UIWikiVersionSelect;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.action.RestoreRevisionActionComponent;
import org.exoplatform.wiki.webui.control.action.ShowHistoryActionListener;
import org.exoplatform.wiki.webui.core.UIWikiContainer;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiVersionSelect.gtmpl", events={@EventConfig(listeners={CompareRevisionActionListener.class}), @EventConfig(listeners={ShowHistoryActionListener.class}), @EventConfig(listeners={NextVersionActionListener.class}), @EventConfig(listeners={PreviousVersionActionListener.class})})
public class UIWikiVersionSelect
extends UIWikiContainer {
    private String versionName;
    public static final String VIEW_CURRENT_VERSION = "ViewCurrentVersion";
    public static final String COMPARE_ACTION = "CompareRevision";
    public static final String RESTORE_ACTION = "Restore";
    public static final String SHOW_HISTORY = "ShowHistory";
    public static final String NEXT_VERSION = "NextVersion";
    public static final String PREVIOUS_VERSION = "PreviousVersion";
    public static final String VIEW_REVISION = "ViewRevision";
    public static final String EXTENSION_TYPE = "org.exoplatform.wiki.webui.UIWikiVersionSelect";

    public UIWikiVersionSelect() throws Exception {
        this.accept_Modes = Arrays.asList(WikiMode.VIEWREVISION);
        this.addChild(RestoreRevisionActionComponent.class, null, null);
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    protected boolean isHasPreviousVersion() {
        int version = Integer.valueOf(this.versionName);
        return version > 1;
    }

    protected boolean isHasNextVersion() throws Exception {
        PageImpl wikipage = (PageImpl)Utils.getCurrentWikiPage();
        int versionTotals = wikipage.getVersionableMixin().getVersionHistory().getChildren().size() - 1;
        int version = Integer.valueOf(this.versionName);
        return version < versionTotals;
    }

    protected boolean renderRestoreRevisionActions() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle bundle = context.getApplicationResourceBundle();
        RestoreRevisionActionComponent component = (RestoreRevisionActionComponent)this.getChild(RestoreRevisionActionComponent.class);
        component.setVersionName(this.versionName);
        component.setCurrentVersion(!this.isHasNextVersion());
        component.setLabel(bundle.getString("UIWikiVersionSelect.label.RestoreThisVersion"));
        component.setTooltip(bundle.getString("UIWikiVersionSelect.label.RestoreThisVersion"));
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        if (manager.accept(EXTENSION_TYPE, "RestoreRevision", null)) {
            this.renderChild(RestoreRevisionActionComponent.class);
            return true;
        }
        return false;
    }

    static /* synthetic */ String access$000(UIWikiVersionSelect x0) {
        return x0.versionName;
    }

    static /* synthetic */ String access$002(UIWikiVersionSelect x0, String x1) {
        x0.versionName = x1;
        return x0.versionName;
    }
}

