/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.commons;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.util.ReflectionUtil;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.Utils;

@ComponentConfig(template="app:/templates/wiki/webui/UIWikiDraftGrid.gtmpl")
@Serialized
public class UIWikiDraftGrid
extends UIComponent {
    public static final String SORT_ASC = "ASC";
    public static final String SORT_DESC = "DESC";
    private Map<String, String> actionForField = new HashMap();
    private String fieldToDisplayBreadCrumb;
    private String sortField;
    private boolean isASC;
    protected UIPageIterator uiIterator_;
    protected String beanIdField_;
    protected String[] beanField_;
    protected String[] action_;
    protected String label_;
    protected boolean useAjax = true;
    protected int displayedChars_ = 30;
    private HashMap<String, List<BreadcrumbData>> breadCrumbs = new HashMap();

    public UIWikiDraftGrid() throws Exception {
        this.uiIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, null);
        this.uiIterator_.setParent((UIComponent)this);
    }

    public void clearBreadcrum() {
        this.breadCrumbs.clear();
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiIterator_;
    }

    public void setActionForField(String field, String action) {
        this.actionForField.put(field, action);
    }

    public String getActionForField(String field) {
        return (String)this.actionForField.get(field);
    }

    public void putBreadCrumbDatas(String key, List<BreadcrumbData> breakCrumbDatas) throws Exception {
        this.breadCrumbs.put(key, breakCrumbDatas);
    }

    public String getBreadCrumb(String key) {
        List breadcrumbDatas = (List)this.breadCrumbs.get(key);
        if (breadcrumbDatas == null) {
            return null;
        }
        StringBuilder breadCrum = new StringBuilder();
        for (int i = 0; i < breadcrumbDatas.size(); ++i) {
            breadCrum.append(((BreadcrumbData)breadcrumbDatas.get(i)).getTitle());
            breadCrum.append(" >> ");
        }
        breadCrum.delete(breadCrum.length() - 4, breadCrum.length());
        return breadCrum.toString();
    }

    public WikiPageParams getPageParam(String key) throws Exception {
        List breadcrumbDatas = (List)this.breadCrumbs.get(key);
        if (breadcrumbDatas != null && breadcrumbDatas.size() > 0) {
            WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
            return wservice.getWikiPageParams((BreadcrumbData)breadcrumbDatas.get(breadcrumbDatas.size() - 1));
        }
        return null;
    }

    public String getFieldToDisplayBreadCrumb() {
        return this.fieldToDisplayBreadCrumb;
    }

    public void setFieldToDisplayBreadCrumb(String fieldToDisplayBreadCrumb) {
        this.fieldToDisplayBreadCrumb = fieldToDisplayBreadCrumb;
    }

    public String getWikiName(String key) throws Exception {
        WikiPageParams params = this.getPageParam(key);
        if (params != null) {
            String wikiName = params.getOwner();
            int index = wikiName.lastIndexOf(47);
            if (index > -1) {
                wikiName = wikiName.substring(index + 1);
            }
            return wikiName;
        }
        return null;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public boolean isASC() {
        return this.isASC;
    }

    public void setASC(boolean isASC) {
        this.isASC = isASC;
    }

    public String createActionLink(BreadcrumbData breadCumbData) throws Exception {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        StringBuilder sb = new StringBuilder(portalRequestContext.getPortalURI());
        UIPortal uiPortal = Util.getUIPortal();
        String pageNodeSelected = uiPortal.getSelectedUserNode().getURI();
        sb.append(pageNodeSelected);
        sb.append("/");
        if (!PortalConfig.PORTAL_TYPE.equalsIgnoreCase(breadCumbData.getWikiType())) {
            sb.append(breadCumbData.getWikiType());
            sb.append("/");
            sb.append(Utils.validateWikiOwner((String)breadCumbData.getWikiType(), (String)breadCumbData.getWikiOwner()));
            sb.append("/");
        }
        sb.append(breadCumbData.getId());
        return sb.toString();
    }

    public UIWikiDraftGrid configure(String beanIdField, String[] beanField, String[] action) {
        this.beanIdField_ = beanIdField;
        this.beanField_ = beanField;
        this.action_ = action;
        return this;
    }

    public String getBeanIdField() {
        return this.beanIdField_;
    }

    public String[] getBeanFields() {
        return this.beanField_;
    }

    public String[] getBeanActions() {
        return this.action_;
    }

    public List<?> getBeans() throws Exception {
        return this.uiIterator_.getCurrentPageData();
    }

    public String getLabel() {
        return this.label_;
    }

    public void setLabel(String label) {
        this.label_ = label;
    }

    public Object getFieldValue(Object bean, String field) throws Exception {
        Method method = ReflectionUtil.getGetBindingMethod((Object)bean, (String)field);
        return method.invoke(bean, ReflectionUtil.EMPTY_ARGS);
    }

    public String getBeanIdFor(Object bean) throws Exception {
        return this.getFieldValue(bean, this.beanIdField_).toString();
    }

    public UIComponent findComponentById(String lookupId) {
        if (this.uiIterator_.getId().equals(lookupId)) {
            return this.uiIterator_;
        }
        return super.findComponentById(lookupId);
    }

    public boolean isUseAjax() {
        return this.useAjax;
    }

    public void setUseAjax(boolean value) {
        this.useAjax = value;
    }

    public int getDisplayedChars() {
        return this.displayedChars_;
    }

    public void setDisplayedChars(int displayedChars) {
        this.displayedChars_ = displayedChars;
    }
}

