/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.popup;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.commons.EventUIComponent;
import org.exoplatform.webui.commons.UISpacesSwitcher;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.webui.UIWikiEmptyAjaxBlock;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.tree.UITreeExplorer;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="/templates/wiki/webui/popup/UIWikiSelectPageForm.gtmpl", events={@EventConfig(listeners={SetCurrentPageActionListener.class}), @EventConfig(listeners={SelectPageActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={SwitchSpaceActionListener.class})})
public class UIWikiSelectPageForm
extends UIForm
implements UIPopupComponent {
    private static final Log log = ExoLogger.getLogger(UIWikiSelectPageForm.class);
    public static final String FORM_ID = "UIWikiSelectPageForm";
    private String currentNodeValue = "";
    public static final String UI_TREE_ID = "UIPageTree";
    private static final String SWITCH_SPACE_ACTION = "SwitchSpace";
    private static final String SPACE_SWITCHER = "uiSpaceSwitcher_UIWikiSelectPageForm";
    private List<UIComponent> updatedComponents = new ArrayList<UIComponent>();

    public UIWikiSelectPageForm() throws Exception {
        this.setId(FORM_ID);
        UITreeExplorer uiTree = (UITreeExplorer)this.addChild(UITreeExplorer.class, null, UI_TREE_ID);
        EventUIComponent eventComponent = new EventUIComponent(FORM_ID, "SetCurrentPage", EventUIComponent.EVENTTYPE.EVENT);
        StringBuilder initURLSb = new StringBuilder(Utils.getCurrentRestURL());
        initURLSb.append("/wiki/tree/").append(TreeNode.TREETYPE.ALL.toString());
        StringBuilder childrenURLSb = new StringBuilder(Utils.getCurrentRestURL());
        childrenURLSb.append("/wiki/tree/").append(TreeNode.TREETYPE.CHILDREN.toString());
        uiTree.init(initURLSb.toString(), childrenURLSb.toString(), this.getInitParam(URLEncoder.encode(Utils.getCurrentWikiPagePath(), "utf-8")), eventComponent, false);
        UISpacesSwitcher uiWikiSpaceSwitcher = (UISpacesSwitcher)this.addChild(UISpacesSwitcher.class, null, SPACE_SWITCHER);
        uiWikiSpaceSwitcher.setCurrentSpaceName(Utils.upperFirstCharacter(Utils.getCurrentSpaceName()));
        uiWikiSpaceSwitcher.setAutoResize(true);
        EventUIComponent eventComponent1 = new EventUIComponent(FORM_ID, SWITCH_SPACE_ACTION, EventUIComponent.EVENTTYPE.EVENT);
        uiWikiSpaceSwitcher.init(eventComponent1);
    }

    public void addUpdatedComponent(UIComponent component) {
        this.updatedComponents.add(component);
    }

    public void removeUpdatedComponent(UIComponent component) {
        this.updatedComponents.remove(component);
    }

    private String getInitParam(String currentPath) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("?").append("path").append("=").append(currentPath).append("&").append("page").append("=").append(currentPath);
        return sb.toString();
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public static class SwitchSpaceActionListener
    extends EventListener<UIWikiSelectPageForm> {
        public void execute(Event<UIWikiSelectPageForm> event) throws Exception {
            String wikiId = event.getRequestContext().getRequestParameter("spaceId");
            UIWikiSelectPageForm uiWikiSelectPageForm = (UIWikiSelectPageForm)((Object)event.getSource());
            UISpacesSwitcher uiWikiSpaceSwitcher = (UISpacesSwitcher)uiWikiSelectPageForm.getChildById(UIWikiSelectPageForm.SPACE_SWITCHER);
            WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
            Wiki wiki = wikiService.getWikiById(wikiId);
            Page wikiHome = wiki.getWikiHome();
            WikiPageParams params = new WikiPageParams(wiki.getType(), wiki.getOwner(), wikiHome.getName());
            uiWikiSpaceSwitcher.setCurrentSpaceName(Utils.upperFirstCharacter(wikiService.getWikiNameById(wikiId)));
            UITreeExplorer uiTree = (UITreeExplorer)uiWikiSelectPageForm.getChildById(UIWikiSelectPageForm.UI_TREE_ID);
            StringBuilder initParams = new StringBuilder();
            initParams.append("?").append("path").append("=").append(TreeUtils.getPathFromPageParams((WikiPageParams)params)).append("&").append("page").append("=").append(Utils.getCurrentWikiPagePath());
            uiTree.setInitParam(initParams.toString());
            event.getRequestContext().addUIComponentToUpdateByAjax(uiWikiSelectPageForm.getParent());
        }
    }

    public static class CancelActionListener
    extends EventListener<UIWikiSelectPageForm> {
        public void execute(Event<UIWikiSelectPageForm> event) throws Exception {
            UIWikiSelectPageForm uiform = (UIWikiSelectPageForm)((Object)event.getSource());
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)uiform.getAncestorOfType(UIWikiPortlet.class);
            UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            popupContainer.cancelPopupAction();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
        }
    }

    public static class SelectPageActionListener
    extends EventListener<UIWikiSelectPageForm> {
        public void execute(Event<UIWikiSelectPageForm> event) throws Exception {
            UIWikiPortlet wikiPortlet;
            UIWikiSelectPageForm uiform;
            block4: {
                uiform = (UIWikiSelectPageForm)((Object)event.getSource());
                wikiPortlet = (UIWikiPortlet)uiform.getAncestorOfType(UIWikiPortlet.class);
                try {
                    if (uiform.currentNodeValue.length() > 0) {
                        String currentNodeValue = TitleResolver.getId((String)uiform.currentNodeValue, (boolean)false);
                        WikiPageParams params = TreeUtils.getPageParamsFromPath((String)currentNodeValue);
                        WikiService service = (WikiService)uiform.getApplicationComponent(WikiService.class);
                        service.addRelatedPage(Utils.getCurrentWikiPageParams(), params);
                    }
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)"can not execute 'SelectPage' action", (Throwable)e);
                }
            }
            UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            popupContainer.cancelPopupAction();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
            for (UIComponent c : uiform.updatedComponents) {
                event.getRequestContext().addUIComponentToUpdateByAjax(c);
            }
        }
    }

    public static class SetCurrentPageActionListener
    extends EventListener<UIWikiSelectPageForm> {
        public void execute(Event<UIWikiSelectPageForm> event) throws Exception {
            UIWikiSelectPageForm uiform = (UIWikiSelectPageForm)((Object)event.getSource());
            UIWikiEmptyAjaxBlock emptyBlock = (UIWikiEmptyAjaxBlock)((UIWikiPortlet)uiform.getAncestorOfType(UIWikiPortlet.class)).getChild(UIWikiEmptyAjaxBlock.class);
            String param = event.getRequestContext().getRequestParameter("objectId");
            if (param != null) {
                uiform.currentNodeValue = param;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)emptyBlock);
        }
    }
}

