/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiRichTextArea.gtmpl")
public class UIWikiRichTextArea
extends UIContainer {
    private static final Log log = ExoLogger.getLogger((String)"wiki:UIWikiRichTextArea");
    private static final String RICHTEXT_AREA_INPUT = "UIWikiRichTextArea_TextArea";
    public static final String SESSION_KEY = "WIKI_RICH_TEXT_AREA_CONTENT";
    public static final String WIKI_CONTEXT = "WIKI_CONTEXT";

    public UIWikiRichTextArea() {
        UIFormTextAreaInput richTextAreaInput = new UIFormTextAreaInput(RICHTEXT_AREA_INPUT, RICHTEXT_AREA_INPUT, "");
        this.addChild((UIComponent)richTextAreaInput);
    }

    public UIFormTextAreaInput getUIFormTextAreaInput() {
        return (UIFormTextAreaInput)this.findComponentById(RICHTEXT_AREA_INPUT);
    }

    protected String getRestUrlToViewCurrentPage() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("/").append(PortalContainer.getCurrentPortalContainerName()).append("/");
            sb.append(PortalContainer.getCurrentRestContextName()).append("/wiki");
            sb.append("/content").append("?sessionKey=").append(SESSION_KEY).append("&wikiContext=").append(WIKI_CONTEXT);
            return sb.toString();
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            return "target:blank";
        }
    }

    protected String getSyntax() throws Exception {
        return Utils.getCurrentPreferences().getPreferencesSyntax().getDefaultSyntax();
    }

    protected WikiPageParams getCurrentWikiPageParams() {
        WikiPageParams wikiPageParams = null;
        try {
            wikiPageParams = Utils.getCurrentWikiPageParams();
        }
        catch (Exception e) {
            log.warn((Object)"Can't get current wiki page params", (Throwable)e);
        }
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        if (wikiPortlet.getWikiMode() == WikiMode.ADDPAGE) {
            wikiPageParams.setPageId(org.exoplatform.wiki.utils.Utils.getPageNameForAddingPage());
        }
        return wikiPageParams;
    }
}

