/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Attachment;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.impl.WikiPageHistory;
import org.exoplatform.wiki.webui.EditMode;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiRichTextArea;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.filter.IsEditAddModeFilter;
import org.exoplatform.wiki.webui.control.filter.IsEditAddPageModeFilter;
import org.exoplatform.wiki.webui.control.listener.UISubmitToolBarActionListener;
import org.xwiki.rendering.syntax.Syntax;

@ComponentConfig(template="app:/templates/wiki/webui/control/action/SavePageActionComponent.gtmpl", events={@EventConfig(listeners={SavePageActionListener.class}, phase=Event.Phase.DECODE)})
public class SavePageActionComponent
extends UIComponent {
    public static final String ACTION = "SavePage";
    private static final Log log = ExoLogger.getLogger((String)"wiki:SavePageActionComponent");
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsEditAddModeFilter(), new IsEditAddPageModeFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    protected boolean isNewMode() {
        return WikiMode.ADDPAGE.equals((Object)((UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class)).getWikiMode());
    }

    protected String getPageTitleInputId() {
        return "titleInput";
    }

    protected String getActionLink() throws Exception {
        return Utils.createFormActionLink(this, ACTION, ACTION);
    }

    public static class SavePageActionListener
    extends UISubmitToolBarActionListener<SavePageActionComponent> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processEvent(Event<SavePageActionComponent> event) throws Exception {
            WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((SavePageActionComponent)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
            Page page = Utils.getCurrentWikiPage();
            if (page != null) {
                String markup;
                String title;
                UIWikiPageTitleControlArea pageTitleControlForm = (UIWikiPageTitleControlArea)wikiPortlet.findComponentById("UIWikiPageTitleControlForm_PageControlArea");
                UIWikiPageEditForm pageEditForm = (UIWikiPageEditForm)wikiPortlet.findFirstComponentOfType(UIWikiPageEditForm.class);
                UIWikiRichTextArea wikiRichTextArea = (UIWikiRichTextArea)pageEditForm.getChild(UIWikiRichTextArea.class);
                UIFormStringInput titleInput = ((UIWikiPageTitleControlArea)pageEditForm.getChild(UIWikiPageTitleControlArea.class)).getUIStringInput();
                UIFormTextAreaInput markupInput = (UIFormTextAreaInput)pageEditForm.findComponentById("Markup");
                UIFormStringInput commentInput = (UIFormStringInput)pageEditForm.findComponentById("Comment");
                String syntaxId = Utils.getDefaultSyntax();
                RenderingService renderingService = (RenderingService)PortalContainer.getComponent(RenderingService.class);
                Utils.setUpWikiContext(wikiPortlet);
                String currentUser = org.exoplatform.wiki.utils.Utils.getCurrentUser();
                boolean isRenamedPage = false;
                boolean isContentChange = false;
                if (wikiPortlet.getWikiMode() == WikiMode.ADDPAGE && (titleInput.getValue() == null || ((String)titleInput.getValue()).isEmpty())) {
                    WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                    ResourceBundle res = context.getApplicationResourceBundle();
                    titleInput.setValue((Object)res.getString("UIWikiPageTitleControlArea.label.Untitled"));
                }
                if (StringUtils.isBlank((String)(title = ((String)titleInput.getValue()).trim()))) {
                    event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("WikiPageNameValidator.msg.EmptyTitle", null, 1));
                    Utils.redirect(Utils.getCurrentWikiPageParams(), WikiMode.EDITPAGE);
                    return;
                }
                if (title.length() > 512) {
                    event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("WikiPageNameValidator.msg.TooLongTitle", new Object[]{512}, 1));
                    Utils.redirect(Utils.getCurrentWikiPageParams(), WikiMode.EDITPAGE);
                    return;
                }
                if (wikiRichTextArea.isRendered()) {
                    String htmlContent = (String)wikiRichTextArea.getUIFormTextAreaInput().getValue();
                    markup = renderingService.render(htmlContent, Syntax.XHTML_1_0.toIdString(), syntaxId, false);
                    markupInput.setValue((Object)markup);
                } else {
                    markup = markupInput.getValue() == null ? "" : (String)markupInput.getValue();
                    markup = markup.trim();
                }
                String newPageName = TitleResolver.getId((String)title, (boolean)false);
                if (!("WikiHome".equals(page.getName()) && wikiPortlet.getWikiMode() == WikiMode.EDITPAGE || newPageName.equals(page.getName()) && wikiPortlet.getWikiMode() == WikiMode.EDITPAGE || !wikiService.isExisting(pageParams.getType(), pageParams.getOwner(), newPageName))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The title '" + title + "' is already existing!"));
                    }
                    event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("SavePageAction.msg.warning-page-title-already-exist", null, 1));
                    if (wikiRichTextArea.isRendered()) {
                        SavePageActionComponent component = (SavePageActionComponent)((Object)event.getSource());
                        UIWikiPageEditForm wikiPageEditForm = (UIWikiPageEditForm)component.getAncestorOfType(UIWikiPageEditForm.class);
                        Utils.feedDataForWYSIWYGEditor(wikiPageEditForm, null);
                    }
                    Utils.redirect(pageParams, wikiPortlet.getWikiMode());
                    return;
                }
                try {
                    if (wikiPortlet.getWikiMode() == WikiMode.EDITPAGE) {
                        UICheckBoxInput publishActivityCheckBox;
                        if (wikiPortlet.getEditMode() == EditMode.SECTION) {
                            newPageName = page.getName();
                            title = page.getTitle();
                            markup = renderingService.updateContentOfSection(page.getContent(), page.getSyntax(), wikiPortlet.getSectionIndex(), markup);
                            isContentChange = true;
                        }
                        page.setMinorEdit(!(publishActivityCheckBox = (UICheckBoxInput)wikiPortlet.findComponentById("PublishActivityUpper")).isChecked());
                        pageEditForm.synPublishActivityStatus(false);
                        if (!page.getTitle().equals(title)) {
                            isRenamedPage = true;
                        }
                        if (!"WikiHome".equals(page.getName()) && !page.getName().equals(newPageName)) {
                            wikiService.renamePage(pageParams.getType(), pageParams.getOwner(), page.getName(), newPageName, title);
                            page.setName(newPageName);
                        }
                        String wikiPageEditForm = page.getId();
                        synchronized (wikiPageEditForm) {
                            page.setComment((String)commentInput.getValue());
                            page.setAuthor(currentUser);
                            page.setSyntax(syntaxId);
                            pageTitleControlForm.getUIFormInputInfo().setValue((Object)title);
                            pageParams.setPageName(page.getName());
                            page.setUrl(Utils.getURLFromParams(pageParams));
                            if (!page.getContent().equals(markup)) {
                                page.setContent(markup);
                                isContentChange = true;
                            }
                            if (!pageEditForm.getTitle().equals(title)) {
                                page.setTitle(title);
                            }
                            PageUpdateType updateType = null;
                            if (isRenamedPage && isContentChange) {
                                updateType = PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE;
                            } else if (isRenamedPage) {
                                updateType = PageUpdateType.EDIT_PAGE_TITLE;
                            } else if (isContentChange) {
                                updateType = PageUpdateType.EDIT_PAGE_CONTENT;
                            }
                            wikiService.updatePage(page, updateType);
                            wikiService.createVersionOfPage(page);
                            if (!"__anonim".equals(currentUser)) {
                                wikiService.removeDraftOfPage(pageParams);
                            }
                        }
                    }
                    if (wikiPortlet.getWikiMode() == WikiMode.ADDPAGE) {
                        Page draftPage = Utils.getCurrentNewDraftWikiPage();
                        List attachments = wikiService.getAttachmentsOfPage(draftPage, true);
                        Wiki wiki = new Wiki(pageParams.getType(), pageParams.getOwner());
                        pageParams.setPageName(newPageName);
                        Page newPage = new Page();
                        newPage.setName(title);
                        newPage.setTitle(title);
                        newPage.setAuthor(currentUser);
                        newPage.setOwner(currentUser);
                        newPage.setContent(markup);
                        newPage.setSyntax(syntaxId);
                        newPage.setUrl(Utils.getURLFromParams(pageParams));
                        Page createdPage = wikiService.createPage(wiki, page.getName(), newPage);
                        for (Attachment attachment : attachments) {
                            wikiService.addAttachmentToPage(attachment, createdPage);
                        }
                        try {
                            wikiService.removeDraft(draftPage.getName());
                            Page parentPage = wikiService.getParentPageOf(createdPage);
                            DraftPage contentDraftPage = this.findTheMatchDraft(title, parentPage);
                            if (contentDraftPage == null) {
                                Map pageLogs = org.exoplatform.wiki.utils.Utils.getLogOfPage((String)parentPage.getName());
                                WikiPageHistory log = (WikiPageHistory)pageLogs.get(currentUser);
                                if (log != null && log.isNewPage() && wikiService.getDraft(log.getDraftName()) != null) {
                                    wikiService.removeDraft(log.getDraftName());
                                }
                            } else {
                                wikiService.removeDraft(contentDraftPage.getName());
                            }
                        }
                        catch (WikiException e) {
                            log.error((Object)("Cannot delete draft of new page " + createdPage.getWikiType() + ":" + createdPage.getWikiOwner() + ":" + createdPage.getName() + " when saving it -  Cause : " + e.getMessage()), (Throwable)e);
                        }
                    }
                    org.exoplatform.wiki.utils.Utils.removeLogEditPage((WikiPageParams)pageParams, (String)currentUser);
                }
                catch (Exception e) {
                    log.error((Object)("An exception happens when saving the page with title:" + title), (Throwable)e);
                    event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIPageToolBar.msg.Exception", null, 0));
                }
                finally {
                    wikiPortlet.changeMode(WikiMode.VIEW);
                    Utils.redirect(pageParams, WikiMode.VIEW);
                }
            } else {
                wikiPortlet.changeMode(WikiMode.VIEW);
                Utils.redirect(pageParams, WikiMode.VIEW);
            }
        }

        private DraftPage findTheMatchDraft(String pageTitle, Page parentPage) throws WikiException {
            WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
            String parentUUID = parentPage.getId();
            String currentUser = org.exoplatform.wiki.utils.Utils.getCurrentUser();
            List draftPages = wikiService.getDraftsOfUser(currentUser);
            for (DraftPage draftPage : draftPages) {
                if (draftPage.getTitle() == null || !draftPage.getTitle().equals(pageTitle) || draftPage.getTargetPageId() == null || !draftPage.getTargetPageId().equals(parentUUID)) continue;
                return draftPage;
            }
            return null;
        }
    }
}

