/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ws.rest.simple;

import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.StringInputTransformer;
import org.exoplatform.services.rest.transformer.StringOutputTransformer;
import org.exoplatform.services.ws.rest.simple.SimpleStorage;

@URITemplate(value="/ejb/simple-service/")
public class SimpleService
implements ResourceContainer {
    private static final Log LOGGER = ExoLogger.getLogger(SimpleService.class);
    private SimpleStorage storage_;

    public SimpleService(SimpleStorage storage) {
        this.storage_ = storage;
    }

    private SimpleStorage getStorage() throws Exception {
        return this.storage_;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/{id}/")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response get(@URIParam(value="id") String id) {
        LOGGER.info((Object)(">>> [GET] " + id));
        try {
            String data = (String)this.getStorage().get(Integer.valueOf(id));
            if (data != null) {
                return Response.Builder.ok((Object)data).build();
            }
            return Response.Builder.notFound().build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Can't get object, object id " + id));
            e.printStackTrace();
            return Response.Builder.serverError().build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/{id}/")
    @InputTransformer(value=StringInputTransformer.class)
    public Response post(String data, @URIParam(value="id") String id) throws Exception {
        LOGGER.info((Object)(">>> [POST] " + id));
        try {
            this.getStorage().set(Integer.valueOf(id), data);
            return Response.Builder.noContent().build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Can't change object, object id " + id));
            e.printStackTrace();
            return Response.Builder.serverError().build();
        }
    }

    @HTTPMethod(value="PUT")
    @InputTransformer(value=StringInputTransformer.class)
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response put(String data) throws Exception {
        LOGGER.info((Object)(">>> [PUT], data: " + data));
        try {
            SimpleStorage ms = this.getStorage();
            ms.add(data);
            return Response.Builder.ok((Object)("Add new object with id " + (ms.size() - 1))).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Can't add new object.");
            e.printStackTrace();
            return Response.Builder.serverError().build();
        }
    }

    @HTTPMethod(value="DELETE")
    @URITemplate(value="/{id}/")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response delete(@URIParam(value="id") String id) {
        LOGGER.info((Object)(">>> [DELETE]" + id));
        try {
            int index = Integer.valueOf(id);
            return Response.Builder.ok((Object)("Remove object: " + (String)this.getStorage().remove(index))).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Can't remove object, object id " + id));
            e.printStackTrace();
            return Response.Builder.serverError().build();
        }
    }

    @HTTPMethod(value="DELETE")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response clear() {
        LOGGER.info((Object)">>> [CLEAN STORAGE]");
        try {
            this.getStorage().clear();
            return Response.Builder.ok((Object)"Clean storage.").build();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Can't clean storage!");
            e.printStackTrace();
            return Response.Builder.serverError().build();
        }
    }
}

