/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ws.rest.samples;

import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/samples/security")
public class JSR250AnnotationExample
implements ResourceContainer {
    private static final CacheControl CC = new CacheControl();

    @GET
    @Produces(value={"text/plain"})
    @PermitAll
    @Path(value="all")
    public Response get(@Context SecurityContext sc) {
        return Response.ok((Object)("This method is permitted for all authenticated users, caller principal " + sc.getUserPrincipal())).header("Cache-Control", (Object)CC).build();
    }

    @GET
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"exo"})
    @Path(value="exo")
    public Response get2(@Context SecurityContext sc) {
        return Response.ok((Object)("This method is permitted only for users in \"exo\" role, caller principal " + sc.getUserPrincipal())).header("Cache-Control", (Object)CC).build();
    }

    @GET
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"admin"})
    @Path(value="admin")
    public Response get3(@Context SecurityContext sc) {
        return Response.ok((Object)("This method is permitted only for users in \"admin\" role, caller principal " + sc.getUserPrincipal())).header("Cache-Control", (Object)CC).build();
    }

    static {
        CC.setNoCache(true);
    }
}

