/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class SerialInputData
implements Serializable {
    private static final long serialVersionUID = -8333597717110874434L;
    private static final int MAX_BUFFER_SIZE = 204800;
    private InputStream stream;

    public SerialInputData(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream can't be null!");
        }
        this.stream = stream;
    }

    public SerialInputData(byte[] bytes) {
        this(new ByteArrayInputStream(bytes));
    }

    public InputStream getStream() {
        return this.stream;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        int bytes = 0;
        while ((bytes = this.stream.read(buffer)) >= 0) {
            if (bytes <= 0) continue;
            out.writeInt(bytes);
            out.write(buffer, 0, bytes);
        }
        out.writeInt(0);
        this.stream.close();
    }

    private void readObject(ObjectInputStream in) throws IOException {
        boolean overflow = false;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream bout = new ByteArrayOutputStream(204800);
        int bytes = in.readInt();
        while (bytes > 0) {
            in.readFully(buffer, 0, bytes);
            bout.write(buffer, 0, bytes);
            if (bout.size() > 204800) {
                overflow = true;
                break;
            }
            bytes = in.readInt();
        }
        if (!overflow) {
            this.stream = new ByteArrayInputStream(bout.toByteArray());
            return;
        }
        final File file = File.createTempFile("restejb-", null);
        FileOutputStream out = new FileOutputStream(file);
        bout.writeTo(out);
        int bytes2 = in.readInt();
        while (bytes2 > 0) {
            in.readFully(buffer, 0, bytes2);
            ((OutputStream)out).write(buffer, 0, bytes2);
            bytes2 = in.readInt();
        }
        ((OutputStream)out).close();
        this.stream = new FileInputStream(file){
            private boolean removed;
            {
                super(x0);
                this.removed = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    this.removed = file.delete();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() throws IOException {
                try {
                    if (!this.removed) {
                        file.delete();
                    }
                }
                finally {
                    super.finalize();
                }
            }
        };
    }
}

