/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.util;

public class MediaType {
    private String type;
    private String subtype;
    public static final String MEDIA_TYPE_WILDCARD = "*";
    public static final String WILDCARD = "*/*";

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public MediaType(String mediaType) {
        this.type = mediaType.split("/")[0];
        this.subtype = mediaType.split("/")[1];
    }

    public MediaType(String type, String subtype) {
        this.type = type == null ? MEDIA_TYPE_WILDCARD : type;
        this.subtype = subtype == null ? MEDIA_TYPE_WILDCARD : subtype;
    }

    public boolean isCompatible(MediaType other) {
        if (other == null) {
            return false;
        }
        if (this.type.equals(MEDIA_TYPE_WILDCARD) || other.type.equals(MEDIA_TYPE_WILDCARD)) {
            return true;
        }
        if (this.type.equalsIgnoreCase(other.type) && (this.subtype.equals(MEDIA_TYPE_WILDCARD) || other.subtype.equals(MEDIA_TYPE_WILDCARD))) {
            return true;
        }
        return this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype);
    }

    public String toString() {
        return this.type + "/" + this.subtype;
    }
}

