/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.cometd.ext;

import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.ws.frameworks.cometd.transport.ContinuationServiceDelegate;
import org.exoplatform.ws.frameworks.cometd.transport.DelegateMessage;
import org.exoplatform.ws.frameworks.json.transformer.Json2BeanInputTransformer;

public class TransferMessages
implements ResourceContainer {
    private final Log log = ExoLogger.getLogger((String)"ws.CometdTestSendMessage");

    @HTTPMethod(value="POST")
    @URITemplate(value="/ext/sendprivatemessage/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response sendMessage(DelegateMessage transportData) {
        ContinuationServiceDelegate transport = this.getCometdTransport();
        transport.sendMessage(transportData.getExoId(), transportData.getChannel(), transportData.getMessage(), transportData.getId());
        return Response.Builder.ok().build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/ext/sendbroadcastmessage/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response sendBroadcastMessage(DelegateMessage data) {
        ContinuationServiceDelegate transport = this.getCometdTransport();
        transport.sendBroadcastMessage(data.getChannel(), data.getMessage(), data.getId());
        return Response.Builder.ok().build();
    }

    private ContinuationServiceDelegate getCometdTransport() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ContinuationServiceDelegate transport = (ContinuationServiceDelegate)container.getComponentInstanceOfType(ContinuationServiceDelegate.class);
        return transport;
    }
}

