/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.cometd;

import org.apache.commons.logging.Log;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;
import org.mortbay.cometd.continuation.EXoContinuationClient;

public class ContinuationService {
    private static final Log LOGGER = ExoLogger.getLogger((String)"ContinuationService");

    protected AbstractBayeux getBayeux() {
        RootContainer container = RootContainer.getInstance();
        container = container.getPortalContainer("portal");
        EXoContinuationBayeux bayeux = (EXoContinuationBayeux)((Object)container.getComponentInstanceOfType(AbstractBayeux.class));
        return bayeux;
    }

    public void sendMessage(String eXoId, String channel, Object data) {
        EXoContinuationBayeux bayeux = (EXoContinuationBayeux)this.getBayeux();
        bayeux.sendMessage(eXoId, channel, data);
    }

    public EXoContinuationClient getClientByExoId(String exoId) {
        EXoContinuationBayeux bayeux = (EXoContinuationBayeux)this.getBayeux();
        return bayeux.getClientByEXoId(exoId);
    }

    public EXoContinuationClient getClient(String id) {
        EXoContinuationBayeux bayeux = (EXoContinuationBayeux)this.getBayeux();
        return (EXoContinuationClient)bayeux.getClient(id);
    }

    public long getTimeout() {
        EXoContinuationBayeux bayeux = (EXoContinuationBayeux)this.getBayeux();
        return bayeux.getTimeout();
    }

    public String getUserToken(String eXoId) {
        EXoContinuationBayeux bayeux = (EXoContinuationBayeux)this.getBayeux();
        return bayeux.getUserToken(eXoId);
    }
}

