/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd.continuation;

import dojox.cometd.Client;
import dojox.cometd.Message;
import dojox.cometd.SecurityPolicy;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.ServletContext;
import org.mortbay.cometd.ClientImpl;
import org.mortbay.cometd.MessageImpl;
import org.mortbay.cometd.continuation.ContinuationBayeux;
import org.mortbay.cometd.continuation.EXoContinuationClient;

public class EXoContinuationBayeux
extends ContinuationBayeux {
    private static Map userToken = new HashMap();
    transient Random _random;
    private long timeout;

    public EXoContinuationBayeux() {
        this.setSecurityPolicy(new EXoSecurityPolicy());
    }

    public ClientImpl newRemoteClient() {
        EXoContinuationClient client = new EXoContinuationClient(this);
        return client;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    long getRandom(long variation) {
        long l = this._random.nextLong() ^ variation;
        return l < 0L ? -l : l;
    }

    public String getUserToken(String eXoId) {
        if (userToken.containsKey(eXoId)) {
            return (String)userToken.get(eXoId);
        }
        String token = Long.toString(this.getRandom((long)System.identityHashCode((Object)this) ^ System.currentTimeMillis()), 36);
        userToken.put(eXoId, token);
        return token;
    }

    protected void initialize(ServletContext context) {
        super.initialize(context);
        try {
            this._random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception e) {
            context.log("Could not get secure random for ID generation", (Throwable)e);
            this._random = new Random();
        }
        this._random.setSeed(this._random.nextLong() ^ (long)((Object)((Object)this)).hashCode() ^ (long)(context.hashCode() << 32) ^ Runtime.getRuntime().freeMemory());
    }

    public EXoContinuationClient getClientByEXoId(String eXoID) {
        Set ids = this.getClientIDs();
        for (String id : ids) {
            EXoContinuationClient exoClient;
            Client client = this.getClient(id);
            if (!(client instanceof EXoContinuationClient) || (exoClient = (EXoContinuationClient)client).getEXoId() == null || !exoClient.getEXoId().equals(eXoID)) continue;
            return exoClient;
        }
        return null;
    }

    public void sendMessage(String eXoId, String channel, Object data) {
        EXoContinuationClient toClient = this.getClientByEXoId(eXoId);
        this.send((Client)toClient, channel, data, null);
    }

    protected void send(Client toClient, String onChannel, Object data, String id) {
        ClientImpl fromClient = (ClientImpl)this.newClient("EXoContinuationBayeux", null);
        MessageImpl reply = this.newMessage();
        reply.put((Object)"data", data);
        if (id != null) {
            reply.put((Object)"id", (Object)id);
        }
        this.deliver((Client)fromClient, toClient, onChannel, (Message)reply);
        reply.decRef();
    }

    public static class EXoSecurityPolicy
    implements SecurityPolicy {
        public boolean canHandshake(Message message) {
            return this.checkUser(message);
        }

        public boolean canCreate(Client client, String channel, Message message) {
            return client != null && !channel.startsWith("/meta/");
        }

        public boolean canSubscribe(Client client, String channel, Message message) {
            if (!this.checkUser(message)) {
                return false;
            }
            if (((EXoContinuationClient)client).getEXoId() == null) {
                ((EXoContinuationClient)client).setEXoId((String)message.get((Object)"exoId"));
            }
            return client != null && !channel.startsWith("/meta/");
        }

        public boolean canPublish(Client client, String channel, Message message) {
            return client != null && !channel.startsWith("/meta/");
        }

        private boolean checkUser(Message message) {
            String userId = (String)message.get((Object)"exoId");
            String eXoToken = (String)message.get((Object)"exoToken");
            return userId != null && userToken.containsKey(userId) && userToken.get(userId).equals(eXoToken);
        }
    }
}

