/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.cometd.loadbalancer;

import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.StringOutputTransformer;
import org.exoplatform.ws.frameworks.cometd.loadbalancer.LoadBalancer;

public class RESTLoadBalancerService
implements ResourceContainer {
    private final Log log = ExoLogger.getLogger((String)"ws.RESTLoadBalancerService");
    private LoadBalancer balancer;

    public RESTLoadBalancerService(LoadBalancer balancer) {
        this.balancer = balancer;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/cometdurl/{exoid}/")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response getCometdURL(@URIParam(value="exoid") String exoid) {
        String url = this.balancer.connection(exoid);
        if (!url.equals("") && url.length() != 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Client with exoid " + exoid + " get URL " + url + " for cometd connection"));
            }
            return Response.Builder.ok((Object)url).build();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("All nodes are owerflow client with exoid " + exoid + " can't connect to cometd!"));
        }
        return Response.Builder.forbidden().errorMessage("Owerflow!").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/releasecometd/{exoid}/")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response release(@URIParam(value="exoid") String exoid) {
        if (this.balancer.release(exoid)) {
            return Response.Builder.ok().build();
        }
        return Response.Builder.badRequest().build();
    }
}

