/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.cometd.loadbalancer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.ws.frameworks.cometd.loadbalancer.LoadBalancer;
import org.exoplatform.ws.frameworks.cometd.loadbalancer.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancerImpl
implements LoadBalancer {
    private final Log log = ExoLogger.getLogger((String)"ws.LoadBalancerImpl");
    private ConcurrentHashMap<String, Node> nodes = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> connectionMap = new ConcurrentHashMap();

    public LoadBalancerImpl(InitParams params) {
        if (params != null) {
            ObjectParameter parameter = params.getObjectParam("cometd.lb.configuration");
            LoadBalancerConf conf = (LoadBalancerConf)parameter.getObject();
            List<Node> list = conf.getNodes();
            for (Node node : list) {
                this.nodes.put(node.getId(), node);
            }
        }
    }

    @Override
    public void addNode(Node node) {
        this.nodes.put(node.getId(), node);
    }

    @Override
    public String connection(String exoId) {
        return this.getNodeURL(exoId);
    }

    @Override
    public List<String> getAliveNodesURL() {
        ArrayList<String> urls = new ArrayList<String>();
        Collection<Node> ns = this.nodes.values();
        for (Node node : ns) {
            if (!node.isAlive()) continue;
            urls.add(node.getUrl());
        }
        return urls;
    }

    @Override
    public boolean release(String exoId) {
        String id = this.connectionMap.get(exoId);
        if (id != null) {
            Node node = this.nodes.get(id);
            node.delConnection();
            this.connectionMap.remove(exoId);
            this.nodes.put(node.getId(), node);
            return true;
        }
        return false;
    }

    @Override
    public void removeNode(String id) {
        this.nodes.remove(id);
        Set set = this.connectionMap.keySet();
        for (String key : set) {
            if (!this.connectionMap.get(key).equals(id)) continue;
            this.connectionMap.remove(key);
        }
    }

    private String getNodeURL(String exoId) {
        if (this.connectionMap.containsKey(exoId)) {
            return this.nodes.get(this.connectionMap.get(exoId)).getUrl();
        }
        Collection<Node> ns = this.nodes.values();
        for (Node node : ns) {
            if (node.getConnected() >= node.getMaxConnection()) continue;
            node.addConnection();
            this.nodes.put(node.getId(), node);
            this.connectionMap.put(exoId, node.getId());
            return node.getUrl();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Overflow new client cannot connect!");
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LoadBalancerConf {
        private List<Node> nodes = new ArrayList<Node>();

        public List<Node> getNodes() {
            return this.nodes;
        }

        public void setNodes(List<Node> nodes) {
            this.nodes = nodes;
        }
    }
}

