/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.cometd;

import dojox.cometd.Client;
import java.util.Collection;
import org.mortbay.cometd.ChannelImpl;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;
import org.mortbay.cometd.continuation.EXoContinuationClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinuationService {
    private final EXoContinuationBayeux bayeux;

    public ContinuationService(EXoContinuationBayeux bayeux) {
        this.bayeux = bayeux;
    }

    public void sendMessage(String eXoId, String channel, Object data, String id) {
        this.bayeux.sendMessage(eXoId, channel, data, id);
    }

    public EXoContinuationClient getClientByExoId(String exoId) {
        return this.bayeux.getClientByEXoId(exoId);
    }

    public EXoContinuationClient getClient(String id) {
        return (EXoContinuationClient)this.bayeux.getClient(id);
    }

    public Collection<Client> getClients() {
        return this.bayeux.getClients();
    }

    public boolean hasChannel(String channel) {
        return this.bayeux.hasChannel(channel);
    }

    public long getTimeout() {
        return this.bayeux.getTimeout();
    }

    public boolean isSubscribe(String eXoId, String channel) {
        ChannelImpl channelImpl = this.bayeux.getChannel(channel);
        Collection collection = channelImpl.getSubscribers();
        for (Client client : collection) {
            EXoContinuationClient exoClient;
            if (!(client instanceof EXoContinuationClient) || !(exoClient = (EXoContinuationClient)client).getEXoId().equals(eXoId)) continue;
            return true;
        }
        return false;
    }

    public void sendBroadcastMessage(String channel, Object data, String msgId) {
        this.bayeux.sendBroadcastMessage(channel, data, msgId);
    }

    public String getUserToken(String eXoId) {
        return this.bayeux.getUserToken(eXoId);
    }
}

