/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonUtils;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanBuilder {
    /*
     * Unable to fully structure code
     */
    public Object createObject(Class<?> clazz, JsonValue jsonValue) throws Exception {
        object = clazz.newInstance();
        block21: for (Method method : methods = clazz.getMethods()) {
            block38: {
                methodName = method.getName();
                if (!methodName.startsWith("set") || methodName.length() <= "set".length()) continue;
                parameterTypes = method.getParameterTypes();
                if (parameterTypes.length != 1) {
                    throw new JsonException("Each set method must have one parameters.");
                }
                methodParameterClazz = parameterTypes[0];
                key = methodName.substring("set".length());
                v0 = key = key.length() > 1 ? Character.toLowerCase(key.charAt(0)) + key.substring(1) : key.toLowerCase();
                if (!jsonValue.isObject()) {
                    throw new JsonException("Unsupported type of jsonValue here!");
                }
                childJsonValue = jsonValue.getElement(key);
                if (childJsonValue == null) continue;
                if (JsonUtils.isKnownType(methodParameterClazz)) {
                    method.invoke(object, new Object[]{this.createObjectKnownTypes(methodParameterClazz, childJsonValue)});
                    continue;
                }
                type = JsonUtils.getType(methodParameterClazz);
                if (type == null) break block38;
                switch (1.$SwitchMap$org$exoplatform$ws$frameworks$json$impl$JsonUtils$Types[type.ordinal()]) {
                    case 1: {
                        array = this.createArray(methodParameterClazz, childJsonValue);
                        method.invoke(object, new Object[]{array});
                        continue block21;
                    }
                    case 2: {
                        genericParameterTypes = method.getGenericParameterTypes();
                        parameterizedTypeClass = null;
                        if (genericParameterTypes.length == 1) {
                            if (genericParameterTypes[0] instanceof ParameterizedType) {
                                parameterizedType = (ParameterizedType)genericParameterTypes[0];
                                try {
                                    parameterizedTypeClass = (Class)parameterizedType.getActualTypeArguments()[0];
                                }
                                catch (ClassCastException e) {
                                    throw new JsonException("This type of Collection can't be restored from JSON source.\nCollection is parameterized by wrong Type: " + parameterizedType + ".");
                                }
                            } else {
                                throw new JsonException("Collection is not parameterized! Collection<Object> is not supported. \nCollection must be parameterized by any types, or by JavaBean with 'get' and 'set' methods.");
                            }
                        }
                        constructor = null;
                        if (!methodParameterClazz.isInterface() && !Modifier.isAbstract(methodParameterClazz.getModifiers())) ** GOTO lbl54
                        try {
                            constructor = ArrayList.class.asSubclass(methodParameterClazz).getConstructor(new Class[]{Collection.class});
                        }
                        catch (Exception e) {
                            try {
                                constructor = HashSet.class.asSubclass(methodParameterClazz).getConstructor(new Class[]{Collection.class});
                                ** GOTO lbl55
                            }
                            catch (Exception e1) {
                                try {
                                    constructor = LinkedList.class.asSubclass(methodParameterClazz).getConstructor(new Class[]{Collection.class});
                                    ** GOTO lbl55
                                }
                                catch (Exception e2) {}
                            }
                        }
                        ** GOTO lbl55
lbl54:
                        // 1 sources

                        constructor = methodParameterClazz.getConstructor(new Class[]{Collection.class});
lbl55:
                        // 5 sources

                        if (constructor == null) {
                            throw new JsonException("Can't find satisfied constructor for : " + methodParameterClazz);
                        }
                        sourceCollection = new ArrayList<Object>(childJsonValue.size());
                        values = childJsonValue.getElements();
                        while (values.hasNext()) {
                            v = values.next();
                            if (!JsonUtils.isKnownType(parameterizedTypeClass)) {
                                sourceCollection.add(this.createObject(parameterizedTypeClass, v));
                                continue;
                            }
                            sourceCollection.add(this.createObjectKnownTypes(parameterizedTypeClass, v));
                        }
                        constructor.newInstance(new Object[]{sourceCollection});
                        method.invoke(object, new Object[]{constructor.newInstance(new Object[]{sourceCollection})});
                        continue block21;
                    }
                    case 3: {
                        genericParameterTypes = method.getGenericParameterTypes();
                        parameterizedTypeClass = null;
                        if (genericParameterTypes.length == 1) {
                            if (genericParameterTypes[0] instanceof ParameterizedType) {
                                parameterizedType = (ParameterizedType)genericParameterTypes[0];
                                if (!String.class.isAssignableFrom((Class)parameterizedType.getActualTypeArguments()[0])) {
                                    throw new JsonException("Key of Map must be String.");
                                }
                                try {
                                    parameterizedTypeClass = (Class)parameterizedType.getActualTypeArguments()[1];
                                }
                                catch (Exception e) {
                                    throw new JsonException("This type of Map can't be restored from JSON source.\nMap is parameterized by wrong Type: " + parameterizedType + ".");
                                }
                            } else {
                                throw new JsonException("Map is not parameterized! Map<Object, Object> is not supported. \nMap must be parameterized byString and any types or JavaBean with 'get' and 'set' methods.");
                            }
                        }
                        constructor = null;
                        if (!methodParameterClazz.isInterface() && !Modifier.isAbstract(methodParameterClazz.getModifiers())) ** GOTO lbl102
                        try {
                            constructor = HashMap.class.asSubclass(methodParameterClazz).getConstructor(new Class[]{Map.class});
                        }
                        catch (Exception e) {
                            try {
                                constructor = Hashtable.class.asSubclass(methodParameterClazz).getConstructor(new Class[]{Map.class});
                                ** GOTO lbl103
                            }
                            catch (Exception e1) {
                                try {
                                    constructor = LinkedHashMap.class.asSubclass(methodParameterClazz).getConstructor(new Class[]{Map.class});
                                    ** GOTO lbl103
                                }
                                catch (Exception e2) {}
                            }
                        }
                        ** GOTO lbl103
lbl102:
                        // 1 sources

                        constructor = methodParameterClazz.getConstructor(new Class[]{Map.class});
lbl103:
                        // 5 sources

                        if (constructor == null) {
                            throw new JsonException("Can't find satisfied constructor for : " + methodParameterClazz);
                        }
                        sourceMap = new HashMap<String, Object>(childJsonValue.size());
                        keys = childJsonValue.getKeys();
                        while (keys.hasNext()) {
                            k = keys.next();
                            v = childJsonValue.getElement(k);
                            if (!JsonUtils.isKnownType(parameterizedTypeClass)) {
                                sourceMap.put(k, this.createObject(parameterizedTypeClass, v));
                                continue;
                            }
                            sourceMap.put(k, this.createObjectKnownTypes(parameterizedTypeClass, v));
                        }
                        method.invoke(object, new Object[]{constructor.newInstance(new Object[]{sourceMap})});
                        continue block21;
                    }
                    default: {
                        throw new JsonException("Can't restore parameter of method : " + method + " from JSON source.");
                    }
                }
            }
            method.invoke(object, new Object[]{this.createObject(methodParameterClazz, childJsonValue)});
        }
        return object;
    }

    private Object createArray(Class<?> clazz, JsonValue jsonValue) throws Exception {
        Class<?> componentType = clazz.getComponentType();
        Object array = Array.newInstance(componentType, jsonValue.size());
        Iterator<JsonValue> values = jsonValue.getElements();
        int i = 0;
        if (componentType.isArray()) {
            if (JsonUtils.isKnownType(componentType)) {
                while (values.hasNext()) {
                    JsonValue v = values.next();
                    Array.set(array, i++, this.createObjectKnownTypes(componentType, v));
                }
            } else {
                while (values.hasNext()) {
                    JsonValue v = values.next();
                    Array.set(array, i++, this.createArray(componentType, v));
                }
            }
        } else {
            while (values.hasNext()) {
                JsonValue v = values.next();
                Array.set(array, i++, this.createObject(componentType, v));
            }
        }
        return array;
    }

    private Object createObjectKnownTypes(Class<?> clazz, JsonValue jsonValue) throws JsonException {
        JsonUtils.Types t = JsonUtils.getType(clazz);
        switch (t) {
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                return jsonValue.getBooleanValue();
            }
            case BYTE: {
                return jsonValue.getByteValue();
            }
            case SHORT: {
                return jsonValue.getShortValue();
            }
            case INT: {
                return jsonValue.getIntValue();
            }
            case LONG: {
                return jsonValue.getLongValue();
            }
            case FLOAT: {
                return Float.valueOf(jsonValue.getFloatValue());
            }
            case DOUBLE: {
                return jsonValue.getDoubleValue();
            }
            case CHAR: {
                return Character.valueOf(jsonValue.getStringValue().charAt(0));
            }
            case STRING: {
                return jsonValue.getStringValue();
            }
            case ARRAY_BOOLEAN: {
                boolean[] params = new boolean[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getBooleanValue();
                }
                return params;
            }
            case ARRAY_BYTE: {
                byte[] params = new byte[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getByteValue();
                }
                return params;
            }
            case ARRAY_SHORT: {
                short[] params = new short[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getShortValue();
                }
                return params;
            }
            case ARRAY_INT: {
                int[] params = new int[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getIntValue();
                }
                return params;
            }
            case ARRAY_LONG: {
                long[] params = new long[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getLongValue();
                }
                return params;
            }
            case ARRAY_FLOAT: {
                float[] params = new float[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getFloatValue();
                }
                return params;
            }
            case ARRAY_DOUBLE: {
                double[] params = new double[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getDoubleValue();
                }
                return params;
            }
            case ARRAY_CHAR: {
                char[] params = new char[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getStringValue().charAt(0);
                }
                return params;
            }
            case ARRAY_STRING: {
                String[] params = new String[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getStringValue();
                }
                return params;
            }
        }
        throw new JsonException("Unknown type");
    }
}

