/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.impl;

import java.util.Stack;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.exoplatform.ws.frameworks.json.value.impl.ArrayValue;
import org.exoplatform.ws.frameworks.json.value.impl.BooleanValue;
import org.exoplatform.ws.frameworks.json.value.impl.DoubleValue;
import org.exoplatform.ws.frameworks.json.value.impl.LongValue;
import org.exoplatform.ws.frameworks.json.value.impl.NullValue;
import org.exoplatform.ws.frameworks.json.value.impl.ObjectValue;
import org.exoplatform.ws.frameworks.json.value.impl.StringValue;

public class JsonDefaultHandler
implements JsonHandler {
    private String key_;
    private JsonValue current_;
    private Stack<JsonValue> values_ = new Stack();

    public void characters(char[] characters) {
        if (this.current_.isObject()) {
            this.current_.addElement(this.key_, this.parseCharacters(characters));
        } else if (this.current_.isArray()) {
            this.current_.addElement(this.parseCharacters(characters));
        }
    }

    public void endArray() {
        this.current_ = this.values_.pop();
    }

    public void endObject() {
        this.current_ = this.values_.pop();
    }

    public void key(String key) {
        this.key_ = key;
    }

    public void startArray() {
        ArrayValue o = new ArrayValue();
        if (this.current_.isObject()) {
            this.current_.addElement(this.key_, o);
        } else if (this.current_.isArray()) {
            this.current_.addElement(o);
        }
        this.values_.push(this.current_);
        this.current_ = o;
    }

    public void startObject() {
        if (this.current_ == null) {
            this.current_ = new ObjectValue();
            this.values_.push(this.current_);
            return;
        }
        ObjectValue o = new ObjectValue();
        if (this.current_.isObject()) {
            this.current_.addElement(this.key_, o);
        } else if (this.current_.isArray()) {
            this.current_.addElement(o);
        }
        this.values_.push(this.current_);
        this.current_ = o;
    }

    public JsonValue getJsonObject() {
        return this.current_;
    }

    private JsonValue parseCharacters(char[] characters) {
        String s;
        block18: {
            s = new String(characters);
            if (characters[0] == '\"' && characters[characters.length - 1] == '\"') {
                return new StringValue(s.substring(1, s.length() - 1));
            }
            if ("true".equalsIgnoreCase(new String(characters)) || "false".equalsIgnoreCase(s)) {
                return new BooleanValue(Boolean.parseBoolean(new String(characters)));
            }
            if ("null".equalsIgnoreCase(new String(characters))) {
                return new NullValue();
            }
            char c = characters[0];
            if (c >= '0' && c <= '9' || c == '.' || c == '-' || c == '+') {
                if (c == '0') {
                    if (s.length() > 2 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                        try {
                            return new LongValue(Long.parseLong(s.substring(2), 16));
                        }
                        catch (NumberFormatException e) {
                            break block18;
                        }
                    }
                    try {
                        return new LongValue(Long.parseLong(s.substring(1), 8));
                    }
                    catch (NumberFormatException e) {
                        try {
                            return new LongValue(Long.parseLong(s));
                        }
                        catch (NumberFormatException l) {
                            try {
                                return new DoubleValue(Double.parseDouble(s));
                            }
                            catch (NumberFormatException d) {
                                break block18;
                            }
                        }
                    }
                }
                try {
                    return new LongValue(Long.parseLong(s));
                }
                catch (NumberFormatException l) {
                    try {
                        return new DoubleValue(Double.parseDouble(s));
                    }
                    catch (NumberFormatException d) {
                        // empty catch block
                    }
                }
            }
        }
        return new StringValue(s);
    }
}

