/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Stack;
import org.exoplatform.ws.frameworks.json.JsonWriter;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonUtils;

public class JsonWriterImpl
implements JsonWriter {
    private final Stack<JsonUtils.JsonToken> jsonTokens_ = new Stack();
    private final Writer writer_;
    private boolean commaFirst_ = false;

    public JsonWriterImpl(Writer writer) {
        this.writer_ = writer;
    }

    public JsonWriterImpl(OutputStream out) {
        this(new OutputStreamWriter(out));
    }

    public void writeStartObject() throws JsonException {
        if (!this.jsonTokens_.isEmpty() && this.jsonTokens_.peek() != JsonUtils.JsonToken.key && this.jsonTokens_.peek() != JsonUtils.JsonToken.array) {
            throw new JsonException("Syntax error. Unexpected element '{'.");
        }
        try {
            if (this.commaFirst_) {
                this.writer_.write(44);
            }
            this.writer_.write(123);
            if (!this.jsonTokens_.isEmpty() && this.jsonTokens_.peek() == JsonUtils.JsonToken.key) {
                this.jsonTokens_.pop();
            }
            this.jsonTokens_.push(JsonUtils.JsonToken.object);
            this.commaFirst_ = false;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public void writeEndObject() throws JsonException {
        try {
            if (this.jsonTokens_.pop() != JsonUtils.JsonToken.object) {
                throw new JsonException("Sysntax error. Unexpected element '}'.");
            }
            this.writer_.write(125);
            this.commaFirst_ = true;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public void writeStartArray() throws JsonException {
        if (this.jsonTokens_.isEmpty() || this.jsonTokens_.peek() != JsonUtils.JsonToken.key && this.jsonTokens_.peek() != JsonUtils.JsonToken.array) {
            throw new JsonException("Sysntax error. Unexpected element '['..");
        }
        try {
            if (this.commaFirst_) {
                this.writer_.write(44);
            }
            this.writer_.write(91);
            if (this.jsonTokens_.peek() == JsonUtils.JsonToken.key) {
                this.jsonTokens_.pop();
            }
            this.jsonTokens_.push(JsonUtils.JsonToken.array);
            this.commaFirst_ = false;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public void writeEndArray() throws JsonException {
        try {
            if (this.jsonTokens_.pop() != JsonUtils.JsonToken.array) {
                throw new JsonException("Sysntax error. Unexpected element ']'.");
            }
            this.writer_.write(93);
            this.commaFirst_ = true;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public void writeKey(String key) throws JsonException {
        if (key == null) {
            throw new JsonException("Key is null.");
        }
        if (this.jsonTokens_.isEmpty() || this.jsonTokens_.peek() != JsonUtils.JsonToken.object) {
            throw new JsonException("Sysntax error. Unexpected characters '" + key + "'." + this.jsonTokens_);
        }
        try {
            if (this.commaFirst_) {
                this.writer_.write(44);
            }
            this.writer_.write(JsonUtils.getJsonString(key));
            this.writer_.write(58);
            this.commaFirst_ = false;
            this.jsonTokens_.push(JsonUtils.JsonToken.key);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public void writeString(String value) throws JsonException {
        this.write(JsonUtils.getJsonString(value));
    }

    public void writeValue(long value) throws JsonException {
        this.write(Long.toString(value));
    }

    public void writeValue(double value) throws JsonException {
        this.write(Double.toString(value));
    }

    public void writeValue(boolean value) throws JsonException {
        this.write(Boolean.toString(value));
    }

    public void writeNull() throws JsonException {
        this.write("null");
    }

    public void flush() throws JsonException {
        try {
            this.writer_.flush();
        }
        catch (IOException e) {
            new JsonException(e);
        }
    }

    public void close() throws JsonException {
        try {
            this.writer_.close();
        }
        catch (IOException e) {
            new JsonException(e);
        }
    }

    private void write(String value) throws JsonException {
        try {
            if (this.jsonTokens_.isEmpty() || this.jsonTokens_.peek() != JsonUtils.JsonToken.key && this.jsonTokens_.peek() != JsonUtils.JsonToken.array) {
                throw new JsonException("Sysntax error. Unexpected characters '" + value + "'.");
            }
            if (this.commaFirst_) {
                this.writer_.write(44);
            }
            this.writer_.write(value);
            this.commaFirst_ = true;
            if (this.jsonTokens_.peek() == JsonUtils.JsonToken.key) {
                this.jsonTokens_.pop();
            }
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }
}

