/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Stack;
import org.exoplatform.ws.frameworks.json.JsonWriter;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonUtils;

public class JsonWriterImpl
implements JsonWriter {
    private final Stack<JsonUtils.JsonToken> jsonTokens = new Stack();
    private final Writer writer;
    private boolean commaFirst = false;

    public JsonWriterImpl(Writer writer) {
        this.writer = writer;
    }

    public JsonWriterImpl(OutputStream out) {
        this(new OutputStreamWriter(out, JsonUtils.DEFAULT_CHARSET));
    }

    public void writeStartObject() throws JsonException {
        if (!this.jsonTokens.isEmpty() && this.jsonTokens.peek() != JsonUtils.JsonToken.key && this.jsonTokens.peek() != JsonUtils.JsonToken.array) {
            throw new JsonException("Syntax error. Unexpected element '{'.");
        }
        try {
            if (this.commaFirst) {
                this.writer.write(44);
            }
            this.writer.write(123);
            if (!this.jsonTokens.isEmpty() && this.jsonTokens.peek() == JsonUtils.JsonToken.key) {
                this.jsonTokens.pop();
            }
            this.jsonTokens.push(JsonUtils.JsonToken.object);
            this.commaFirst = false;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public void writeEndObject() throws JsonException {
        try {
            if (this.jsonTokens.pop() != JsonUtils.JsonToken.object) {
                throw new JsonException("Sysntax error. Unexpected element '}'.");
            }
            this.writer.write(125);
            this.commaFirst = true;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public void writeStartArray() throws JsonException {
        if (this.jsonTokens.isEmpty() || this.jsonTokens.peek() != JsonUtils.JsonToken.key && this.jsonTokens.peek() != JsonUtils.JsonToken.array) {
            throw new JsonException("Sysntax error. Unexpected element '['..");
        }
        try {
            if (this.commaFirst) {
                this.writer.write(44);
            }
            this.writer.write(91);
            if (this.jsonTokens.peek() == JsonUtils.JsonToken.key) {
                this.jsonTokens.pop();
            }
            this.jsonTokens.push(JsonUtils.JsonToken.array);
            this.commaFirst = false;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public void writeEndArray() throws JsonException {
        try {
            if (this.jsonTokens.pop() != JsonUtils.JsonToken.array) {
                throw new JsonException("Sysntax error. Unexpected element ']'.");
            }
            this.writer.write(93);
            this.commaFirst = true;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public void writeKey(String key) throws JsonException {
        if (key == null) {
            throw new JsonException("Key is null.");
        }
        if (this.jsonTokens.isEmpty() || this.jsonTokens.peek() != JsonUtils.JsonToken.object) {
            throw new JsonException("Sysntax error. Unexpected characters '" + key + "'." + this.jsonTokens);
        }
        try {
            if (this.commaFirst) {
                this.writer.write(44);
            }
            this.writer.write(JsonUtils.getJsonString(key));
            this.writer.write(58);
            this.commaFirst = false;
            this.jsonTokens.push(JsonUtils.JsonToken.key);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public void writeString(String value) throws JsonException {
        this.write(JsonUtils.getJsonString(value));
    }

    public void writeValue(long value) throws JsonException {
        this.write(Long.toString(value));
    }

    public void writeValue(double value) throws JsonException {
        this.write(Double.toString(value));
    }

    public void writeValue(boolean value) throws JsonException {
        this.write(Boolean.toString(value));
    }

    public void writeNull() throws JsonException {
        this.write("null");
    }

    public void flush() throws JsonException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            new JsonException(e);
        }
    }

    public void close() throws JsonException {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            new JsonException(e);
        }
    }

    private void write(String value) throws JsonException {
        try {
            if (this.jsonTokens.isEmpty() || this.jsonTokens.peek() != JsonUtils.JsonToken.key && this.jsonTokens.peek() != JsonUtils.JsonToken.array) {
                throw new JsonException("Sysntax error. Unexpected characters '" + value + "'.");
            }
            if (this.commaFirst) {
                this.writer.write(44);
            }
            this.writer.write(value);
            this.commaFirst = true;
            if (this.jsonTokens.peek() == JsonUtils.JsonToken.key) {
                this.jsonTokens.pop();
            }
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }
}

