/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ws.rest.ejb21;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.MultivaluedMetadata;
import org.exoplatform.services.rest.Request;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.ResourceIdentifier;
import org.exoplatform.services.rest.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestEJBConnectorBean
implements SessionBean {
    static final long serialVersionUID = 234765347623L;
    private ExoContainer container;
    private ResourceDispatcher resDispatcher;
    private static final Log LOGGER = ExoLogger.getLogger(RestEJBConnectorBean.class);
    SessionContext context;

    public String service(String str, String method, String url, HashMap<String, List<String>> headers, HashMap<String, List<String>> queries) {
        try {
            this.container = ExoContainerContext.getContainerByName((String)"portal");
        }
        catch (Exception e) {
            LOGGER.error((Object)"Can't get current container!");
            throw new EJBException("Can't get current container!", e);
        }
        this.resDispatcher = (ResourceDispatcher)this.container.getComponentInstanceOfType(ResourceDispatcher.class);
        if (this.resDispatcher == null) {
            LOGGER.error((Object)"ResourceDispatcher not found in container!");
            throw new EJBException("ResourceDispatcher not found in container!");
        }
        try {
            ByteArrayInputStream dataStream = null;
            if (str != null) {
                dataStream = new ByteArrayInputStream(str.getBytes());
            }
            Request req = new Request((InputStream)dataStream, new ResourceIdentifier(url), method, new MultivaluedMetadata(headers), new MultivaluedMetadata(queries));
            String respString = null;
            Response resp = this.resDispatcher.dispatch(req);
            if (resp.getEntity() != null) {
                respString = (String)resp.getEntity();
            }
            return respString;
        }
        catch (Exception e) {
            LOGGER.error((Object)"This request cann't be serve by service.\nCheck request parameters and try again.");
            throw new EJBException("This request can't be serve!", e);
        }
    }

    public String service(String str, String method, String url) {
        return this.service(str, method, url, new HashMap<String, List<String>>(), new HashMap<String, List<String>>());
    }

    public String service(String method, String url) {
        return this.service(null, method, url, new HashMap<String, List<String>>(), new HashMap<String, List<String>>());
    }

    public void ejbPassivate() {
    }

    public void ejbActivate() {
    }

    public void ejbRemove() {
    }

    public void setSessionContext(SessionContext contx) {
        this.context = contx;
    }

    public void ejbCreate() {
    }
}

