/*
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.exoplatform.services.rest.ext.transport;

import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

import java.io.Serializable;
import java.net.URI;

import javax.ws.rs.core.MultivaluedMap;

/**
 * This class can be used as proxy when need to call RESTful services via RMI
 * (EJB). Usage : client create instance of SerialRequest, lookup EJB, call bean
 * method and pass SerialRequest as method parameter. Bean create instance of
 * {@link GenericContainerRequest}, {@link GenericContainerResponse} then uses
 * {@link RequestHandler}.
 * 
 * @author <a href="mailto:andrew00x@gmail.com">Andrey Parfonov</a>
 * @version $Id: $
 */
public class SerialRequest implements Serializable
{

   /**
    * Generated by Eclipse.
    */
   private static final long serialVersionUID = -1285660043757622945L;

   /**
    * HTTP method.
    */
   private String method;

   /**
    * Resource's URI.
    */
   private URI serviceURI;

   /**
    * See {@link SerialInputData}.
    */
   private SerialInputData data;

   /**
    * HTTP headers.
    */
   private MultivaluedMap<String, String> headers;

   public SerialRequest(String method, URI serviceURI, MultivaluedMap<String, String> headers, SerialInputData data)
   {
      this.method = method;
      this.serviceURI = serviceURI;
      if (headers != null)
         this.headers = headers;
      else
         this.headers = new MultivaluedMapImpl();
      this.data = data;
   }

   /**
    * @return HTTP method, e.g. (GET, POST, DELETE, etc.)
    */
   public String getMethod()
   {
      return method;
   }

   /**
    * @return resource's relative URI
    */
   public URI getUri()
   {
      return serviceURI;
   }

   /**
    * @return HTTP headers, see {@link MultivaluedMap}
    */
   public MultivaluedMap<String, String> getHeaders()
   {
      return headers;
   }

   /**
    * Set HTTP header with supplied name and value, preset header with this name
    * will be overridden.
    * 
    * @param name header name
    * @param value header value
    */
   public void setHeader(String name, String value)
   {
      this.headers.putSingle(name, value);
   }

   /**
    * HTTP header with supplied name and value.
    * 
    * @param name header name
    * @param value header value
    */
   public void addHeader(String name, String value)
   {
      headers.add(name, value);
   }

   /**
    * @return See {@link SerialInputData}
    */
   public SerialInputData getData()
   {
      return data;
   }

}
