/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.groovy;

import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.ext.BaseTest;
import org.exoplatform.services.rest.ext.groovy.BaseResourceId;
import org.exoplatform.services.rest.ext.groovy.ResourceId;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.tools.ByteArrayContainerResponseWriter;
import org.exoplatform.services.test.mock.MockHttpServletRequest;

public class GroovyContextParamTest
extends BaseTest {
    private InputStream script;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.script = Thread.currentThread().getContextClassLoader().getResourceAsStream("groovy1.groovy");
        GroovyContextParamTest.assertNotNull((Object)this.script);
    }

    @Override
    public void tearDown() throws Exception {
        this.groovyPublisher.resources.clear();
        super.tearDown();
    }

    public void testPerRequest() throws Exception {
        GroovyContextParamTest.assertEquals((int)0, (int)this.binder.getSize());
        GroovyContextParamTest.assertEquals((int)0, (int)this.groovyPublisher.resources.size());
        this.groovyPublisher.publishPerRequest(this.script, (ResourceId)new BaseResourceId("g1"), null);
        GroovyContextParamTest.assertEquals((int)1, (int)this.binder.getSize());
        GroovyContextParamTest.assertEquals((int)1, (int)this.groovyPublisher.resources.size());
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest("http://localhost:8080/context/a/b", null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        ContainerResponse resp = this.launcher.service("GET", "http://localhost:8080/context/a/b", "http://localhost:8080/context", null, null, (ContainerResponseWriter)writer, envctx);
        GroovyContextParamTest.assertEquals((int)200, (int)resp.getStatus());
        GroovyContextParamTest.assertEquals((String)"GET\n/context/a/b", (String)new String(writer.getBody()));
    }
}

