/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.cas.client;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;

public abstract class AbstractIdentityInitializerFilter
implements Filter {
    protected Log log = ExoLogger.getLogger((String)"ws.security.AbstractIdentityInitializerFilter");

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        String userId = httpRequest.getRemoteUser();
        IdentityRegistry identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
        Identity identity = identityRegistry.getIdentity(userId);
        if (identity == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Identity is null for " + userId));
            }
            try {
                identity = this.createIdentity(userId);
                identityRegistry.register(identity);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServletException((Throwable)e);
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig config) throws ServletException {
    }

    protected abstract Identity createIdentity(String var1) throws Exception;

    protected abstract ExoContainer getContainer();
}

