/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.http;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;

public class OAuthRequestWrapperFilter
implements Filter {
    private static final Log LOG = ExoLogger.getLogger((String)"ws.security.OAuthRequestWrapperFilter");

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(false);
        Principal principal = null;
        principal = session != null && session.getAttribute("oauth_principal") != null ? (Principal)session.getAttribute("oauth_principal") : (Principal)httpRequest.getAttribute("oauth_principal");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("user principal: " + principal));
        }
        OAuthHttpServletRequestWrapper requestWrapper = new OAuthHttpServletRequestWrapper(httpRequest, principal);
        chain.doFilter((ServletRequest)requestWrapper, response);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    final class OAuthHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final Principal principal;

        OAuthHttpServletRequestWrapper(HttpServletRequest request, Principal principal) {
            super(request);
            this.principal = principal;
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public String getRemoteUser() {
            return this.getUserPrincipal().getName();
        }
    }
}

