/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.http;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthMessage;
import net.oauth.server.OAuthServlet;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.ws.security.oauth.OAuthConsumerService;

public class OAuthCallbackServlet
extends HttpServlet {
    private static final long serialVersionUID = -3941492315142762805L;
    private static final Log LOG = ExoLogger.getLogger((String)"ws.security.OAuthCallbackServlet");

    public void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        OAuthMessage oauthMessage = OAuthServlet.getMessage((HttpServletRequest)httpRequest, null);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        OAuthConsumerService consumerService = (OAuthConsumerService)container.getComponentInstanceOfType(OAuthConsumerService.class);
        try {
            OAuthAccessor accessor = consumerService.getAccessor(oauthMessage);
            if (accessor.accessToken != null) {
                String returnTo = OAuth.decodePercent((String)httpRequest.getParameter("returnTo"));
                if (returnTo == null) {
                    returnTo = httpRequest.getContextPath();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Get access token from Provider, client will be redirect to '" + returnTo + "'."));
                }
                httpResponse.setStatus(307);
                httpResponse.setHeader("Location", returnTo);
                httpResponse.addCookie(new Cookie(accessor.consumer.consumerKey + '.' + "oauth_token", accessor.accessToken));
                httpResponse.addCookie(new Cookie(accessor.consumer.consumerKey + '.' + "oauth_token_secret", accessor.tokenSecret));
            } else {
                httpResponse.sendError(403, "You have not permission for requested resource!");
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

