/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.impl;

import java.util.Iterator;
import java.util.Set;
import net.oauth.OAuthAccessor;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.ws.security.oauth.OAuthTokenCleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OAuthTokenCleanerImpl
extends Thread
implements OAuthTokenCleaner {
    public static final long DEFAULT_TIMEOUT = 300000L;
    private final long timeout;
    private Set<OAuthAccessor> tokens;
    private static final Log LOG = ExoLogger.getLogger((String)"ws.security.OAuthTokenCleanerImpl");

    public OAuthTokenCleanerImpl(InitParams params) {
        ValueParam t = params.getValueParam("tokenCleanerTimeout");
        this.timeout = t != null ? Long.parseLong(t.getValue()) * 60L * 1000L : 300000L;
        LOG.info((Object)("Token Cleaner timeout is " + this.timeout + " ms."));
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.clean();
                    OAuthTokenCleanerImpl.sleep(this.timeout);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public void clean() {
        long currentTime = System.currentTimeMillis();
        if (this.tokens == null) {
            return;
        }
        Iterator<OAuthAccessor> iter = this.tokens.iterator();
        while (iter.hasNext()) {
            OAuthAccessor a = iter.next();
            Object o = a.getProperty("expired");
            if (o == null || (Long)o >= currentTime) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Remove expired accessor: " + a));
            }
            iter.remove();
        }
    }

    @Override
    public void setTokens(Set<OAuthAccessor> tokens) {
        this.tokens = tokens;
    }
}

