/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.http;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthMessage;
import net.oauth.server.OAuthServlet;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.security.jaas.UserPrincipal;
import org.exoplatform.ws.security.oauth.OAuthConsumerService;
import org.exoplatform.ws.security.oauth.http.CookieUtils;

public class OAuthConsumerFilter
implements Filter {
    private String consumerName;
    private static final Log LOG = ExoLogger.getLogger((String)OAuthConsumerFilter.class.getName());

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Cookie c;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        OAuthMessage oauthMessage = OAuthServlet.getMessage((HttpServletRequest)httpRequest, null);
        Cookie[] cookies = httpRequest.getCookies();
        if (oauthMessage.getParameter("oauth_token") == null && (c = CookieUtils.findCookie(this.consumerName + "." + "oauth_token", cookies)) != null) {
            oauthMessage.addParameter("oauth_token", c.getValue());
        }
        if (oauthMessage.getParameter("oauth_token_secret") == null && (c = CookieUtils.findCookie(this.consumerName + "." + "oauth_token_secret", cookies)) != null) {
            oauthMessage.addParameter("oauth_token_secret", c.getValue());
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        OAuthConsumerService consumerService = (OAuthConsumerService)container.getComponentInstanceOfType(OAuthConsumerService.class);
        try {
            oauthMessage.addParameter("oauth_consumer_key", this.consumerName);
            OAuthAccessor accessor = consumerService.getAccessor(oauthMessage);
            if (accessor.accessToken != null) {
                String user;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Access grant, oauth_token " + accessor.accessToken + ", oauth_secret_token " + accessor.tokenSecret));
                }
                if ((user = (String)accessor.getProperty("oauth_user_id")) != null) {
                    Collection roles = (Collection)accessor.getProperty("oauth_user_roles");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("userId " + user + ", roles " + roles));
                    }
                    UserPrincipal principal = new UserPrincipal(user);
                    request.setAttribute("oauth_user_principal", (Object)principal);
                    request.setAttribute("oauth_user_roles", (Object)roles);
                }
                chain.doFilter(request, response);
                return;
            }
            if (accessor.requestToken != null) {
                String authorizationURL = accessor.consumer.serviceProvider.userAuthorizationURL;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Request token generated, request will be redirected to URL '" + authorizationURL + "' for authorization."));
                }
                httpResponse.setStatus(307);
                String url = httpRequest.getRequestURL().toString();
                String query = httpRequest.getQueryString();
                if (query != null) {
                    url = url + '?' + query;
                }
                httpResponse.setHeader("Location", OAuth.addParameters((String)authorizationURL, (String[])new String[]{"oauth_token", accessor.requestToken, "oauth_token_secret", accessor.tokenSecret, "returnTo", OAuth.percentEncode((String)url)}));
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new ServletException((Throwable)e);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.consumerName = config.getInitParameter("consumer");
        if (this.consumerName == null) {
            throw new ServletException("Consumer name is not found in filter init parameters!");
        }
    }
}

