/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.http;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;

public class OAuthIdentityInitializerFilter
implements Filter {
    private static final Log LOG = ExoLogger.getLogger((String)OAuthIdentityInitializerFilter.class.getName());

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        String userId = httpRequest.getRemoteUser();
        IdentityRegistry identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
        Identity identity = identityRegistry.getIdentity(userId);
        if (identity == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Identity is null for " + userId));
            }
            try {
                identity = this.createIdentity(userId);
                identityRegistry.register(identity);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new ServletException((Throwable)e);
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    protected Identity createIdentity(String userId) throws Exception {
        Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Try create identity for user " + userId));
        }
        return authenticator.createIdentity(userId);
    }

    protected ExoContainer getContainer() {
        return ExoContainerContext.getCurrentContainer();
    }

    public void init(FilterConfig config) throws ServletException {
    }
}

