/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.http;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.server.OAuthServlet;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.security.oauth.OAuthConsumerService;
import org.exoplatform.ws.security.oauth.http.CookieUtils;

public class OAuthLogoutFilter
implements Filter {
    private String consumerName;
    private String redirectToUrl;
    private static final Log LOG = ExoLogger.getLogger((String)OAuthLogoutFilter.class.getName());

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String logout = request.getParameter("logout");
        if (logout != null && "yes".equals(logout.toLowerCase())) {
            Cookie c;
            Cookie tokenCookie = null;
            Cookie secretCookie = null;
            OAuthMessage oauthMessage = OAuthServlet.getMessage((HttpServletRequest)httpRequest, null);
            Cookie[] cookies = httpRequest.getCookies();
            if (oauthMessage.getParameter("oauth_token") == null && (c = CookieUtils.findCookie(this.consumerName + "." + "oauth_token", cookies)) != null) {
                oauthMessage.addParameter("oauth_token", c.getValue());
                tokenCookie = c;
            }
            if (oauthMessage.getParameter("oauth_token_secret") == null && (c = CookieUtils.findCookie(this.consumerName + "." + "oauth_token_secret", cookies)) != null) {
                oauthMessage.addParameter("oauth_token_secret", c.getValue());
                secretCookie = c;
            }
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            OAuthConsumerService consumerService = (OAuthConsumerService)container.getComponentInstanceOfType(OAuthConsumerService.class);
            oauthMessage.addParameter("oauth_consumer_key", this.consumerName);
            try {
                consumerService.removeAccessor(oauthMessage);
            }
            catch (OAuthProblemException e) {
                LOG.error((Object)"Can't remove accessor.");
            }
            if (tokenCookie != null) {
                httpResponse.addCookie(CookieUtils.deleteCookie(tokenCookie));
            }
            if (secretCookie != null) {
                httpResponse.addCookie(CookieUtils.deleteCookie(secretCookie));
            }
            if (this.redirectToUrl != null) {
                httpResponse.setStatus(307);
                httpResponse.setHeader("Location", this.redirectToUrl);
                return;
            }
        }
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    public void init(FilterConfig config) throws ServletException {
        this.consumerName = config.getInitParameter("consumer");
        if (this.consumerName == null) {
            throw new ServletException("Consumer name is not found in filter init parameters!");
        }
        this.redirectToUrl = config.getInitParameter("redirectToUrl");
    }
}

