/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.storage.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthProblemException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.security.oauth.storage.GrantedAccessorStorage;
import org.exoplatform.ws.security.oauth.storage.GrantedAccessorStorageProperties;

public class TreeFileGrantedAccessorStorage
extends GrantedAccessorStorage {
    private static final Log LOG = ExoLogger.getLogger((String)TreeFileGrantedAccessorStorage.class.getName());
    private static final int MAX_CACHE_SIZE = 1024;
    private File rootDir;
    private boolean initialized = false;
    private CacheMap cache;

    public synchronized void addAccessor(OAuthAccessor accessor) throws OAuthProblemException {
        File file = new File(this.rootDir, this.buidlFilePath(accessor.accessToken));
        file.getParentFile().mkdirs();
        try {
            TreeFileGrantedAccessorStorage.writeAccessor(file, accessor);
            this.addInCache(accessor);
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new OAuthProblemException("Supplied accessor can not be saved in storage.");
        }
    }

    public OAuthAccessor getAccessor(String token, String secret) throws OAuthProblemException {
        OAuthAccessor accessor = this.fromCache(token);
        if (accessor == null) {
            File file = new File(this.rootDir, this.buidlFilePath(token));
            if (!file.exists()) {
                return null;
            }
            try {
                accessor = TreeFileGrantedAccessorStorage.readAccessor(file);
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new OAuthProblemException("Can't restore accessor from storage");
            }
        }
        this.checkSecretToken(accessor, secret);
        return accessor;
    }

    public synchronized void init(GrantedAccessorStorageProperties properties) throws OAuthProblemException {
        int cacheSize;
        if (this.initialized) {
            return;
        }
        int n = cacheSize = properties.getProperty("cacheSize") != null ? Integer.parseInt(properties.getProperty("cacheSize")) : 1024;
        if (cacheSize > 0) {
            this.cache = new CacheMap(cacheSize);
        } else {
            LOG.info((Object)"Initialized without cache.");
        }
        String rootPath = properties.getProperty("path");
        if (rootPath == null) {
            throw new OAuthProblemException("Root directory for saving granted tickets is not specified, check configuration.");
        }
        this.rootDir = new File(rootPath);
        if (this.rootDir.exists()) {
            if (!this.rootDir.isDirectory()) {
                throw new OAuthProblemException("File " + this.rootDir.getAbsolutePath() + " exists but it is not directory.");
            }
        } else if (this.rootDir.mkdirs()) {
            LOG.info((Object)("Create root directory for oauth tickets " + this.rootDir.getAbsolutePath()));
        } else {
            LOG.warn((Object)("Can't create root directory for oauth tickets " + this.rootDir.getAbsolutePath()));
        }
        this.initialized = true;
    }

    public synchronized void removeAccessor(String token) throws OAuthProblemException {
        this.removeFromCache(token);
        File file = new File(this.rootDir, this.buidlFilePath(token));
        if (file.exists() && file.delete()) {
            this.deleteParent(file.getParentFile());
        }
    }

    private OAuthAccessor fromCache(String token) {
        if (this.cache != null) {
            return (OAuthAccessor)this.cache.get(token);
        }
        return null;
    }

    private void addInCache(OAuthAccessor accessor) {
        if (this.cache != null) {
            this.cache.put(accessor.accessToken, accessor);
        }
    }

    private void removeFromCache(String token) {
        if (this.cache != null) {
            this.cache.remove(token);
        }
    }

    private static void writeAccessor(File file, OAuthAccessor accessor) throws IOException {
        ObjectOutputStream oos = null;
        try {
            FileOutputStream out = new FileOutputStream(file);
            oos = new ObjectOutputStream(out);
            oos.writeObject(accessor);
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new IOException("Can't open file " + file.getAbsolutePath());
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
    }

    private static OAuthAccessor readAccessor(File file) throws IOException {
        ObjectInputStream ois = null;
        try {
            OAuthAccessor accessor;
            FileInputStream in = new FileInputStream(file);
            ois = new ObjectInputStream(in);
            OAuthAccessor oAuthAccessor = accessor = (OAuthAccessor)ois.readObject();
            return oAuthAccessor;
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new IOException("Can't restore accessor from file " + file.getAbsolutePath() + ", not found class " + OAuthAccessor.class.getName());
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }

    protected String buidlFilePath(String token) {
        if (token.split("-").length != 5) {
            throw new IllegalArgumentException("Invalid UUID string: " + token);
        }
        StringBuffer sb = new StringBuffer();
        int strlen = token.length();
        char c = '\u0000';
        for (int i = 0; i < strlen && (c = token.charAt(i)) != '-'; ++i) {
            if (sb.length() > 0) {
                sb.append(File.separatorChar);
            }
            sb.append(c);
        }
        sb.append(token);
        return sb.toString();
    }

    protected boolean deleteParent(File file) {
        String rootPath;
        boolean res = false;
        String path = file.getAbsolutePath();
        if (path.startsWith(rootPath = this.rootDir.getAbsolutePath()) && path.length() > rootPath.length()) {
            if (file.isDirectory()) {
                String[] ls = file.list();
                if (ls.length <= 0) {
                    res = file.delete();
                    if (res) {
                        res = this.deleteParent(new File(file.getParent()));
                    } else {
                        LOG.warn((Object)("Can't remove file " + path));
                    }
                }
            } else {
                LOG.warn((Object)("Parent is a file " + path));
            }
        }
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheMap
    extends LinkedHashMap<String, OAuthAccessor> {
        private static final long serialVersionUID = 4043563002416887500L;
        private static final float LOAD_FACTOR = 0.75f;
        private final int cacheSize;

        public CacheMap(int cacheSize) {
            super(cacheSize, 0.75f, true);
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, OAuthAccessor> eldest) {
            return this.size() >= this.cacheSize;
        }
    }
}

