/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.storage.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthProblemException;
import org.exoplatform.ws.security.oauth.storage.GrantedAccessorStorage;
import org.exoplatform.ws.security.oauth.storage.GrantedAccessorStorageProperties;

public class InmemoryGrantedAccessorStorage
extends GrantedAccessorStorage {
    private final Map<String, OAuthAccessor> storage = new ConcurrentHashMap<String, OAuthAccessor>();

    public void addAccessor(OAuthAccessor accessor) {
        this.storage.put(accessor.accessToken, accessor);
    }

    public OAuthAccessor getAccessor(String token, String secret) throws OAuthProblemException {
        OAuthAccessor accessor = this.storage.get(token);
        if (accessor != null) {
            this.checkSecretToken(accessor, secret);
            return accessor;
        }
        return null;
    }

    public void init(GrantedAccessorStorageProperties properties) {
    }

    public void removeAccessor(String token) {
        this.storage.remove(token);
    }
}

