/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.ws.security.oauth.OAuthProviderService;

public abstract class OAuthProviderServiceImpl
implements OAuthProviderService {
    protected final HashMap<String, OAuthConsumer> consumers = new HashMap();
    protected final HashSet<OAuthAccessor> tokens = new HashSet();
    protected static final Log log = ExoLogger.getLogger((String)"ws.security.OAuthProviderServiceImpl");

    public OAuthProviderServiceImpl(InitParams params) {
        Iterator iterator = params.getPropertiesParamIterator();
        while (iterator.hasNext()) {
            PropertiesParam pp = (PropertiesParam)iterator.next();
            String name = pp.getName();
            String secret = pp.getProperty("secret");
            String description = pp.getProperty("description");
            String callbackURL = pp.getProperty("callbackURL");
            OAuthConsumer consumer = new OAuthConsumer(callbackURL, name, secret, null);
            consumer.setProperty("name", (Object)name);
            consumer.setProperty("description", (Object)description);
            this.consumers.put(name, consumer);
        }
    }

    public OAuthConsumer getConsumer(String name) throws OAuthProblemException {
        OAuthConsumer consumer = this.consumers.get(name);
        if (consumer != null) {
            return consumer;
        }
        throw new OAuthProblemException("There is no appropriate consumer for '" + name + "'.");
    }

    public OAuthAccessor getAccessor(OAuthMessage oauthMessage) throws OAuthProblemException {
        try {
            String token = oauthMessage.getParameter("oauth_token");
            String secret = oauthMessage.getParameter("oauth_token_secret");
            for (OAuthAccessor a : this.tokens) {
                if (a.requestToken == null || !a.requestToken.equals(token) || a.tokenSecret == null || !a.tokenSecret.equals(secret)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Request token found: " + token));
                }
                return a;
            }
            throw new OAuthProblemException("Request token or secret token is invalid.");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OAuthProblemException(e.getMessage());
        }
    }

    public OAuthConsumer getConsumer(OAuthMessage oauthMessage) throws OAuthProblemException {
        String name = null;
        try {
            oauthMessage.requireParameters(new String[]{"oauth_consumer_key"});
            name = oauthMessage.getConsumerKey();
            return this.getConsumer(name);
        }
        catch (IOException e) {
            throw new OAuthProblemException("There is no appropriate consumer for '" + name + "', or '" + "oauth_consumer_key" + "' is not presents in oauth message.");
        }
    }

    public void authorize(OAuthAccessor accessor, String userId) throws OAuthProblemException {
        if (userId == null || userId.length() == 0) {
            throw new OAuthProblemException("User ID can't be null!");
        }
        this.tokens.remove(accessor);
        accessor.setProperty("userId", (Object)userId);
        accessor.setProperty("authorized", (Object)Boolean.TRUE);
        this.tokens.add(accessor);
    }

    public void generateRequestToken(OAuthAccessor accessor) {
        accessor.requestToken = this.generateToken();
        accessor.tokenSecret = this.generateSecret();
        accessor.accessToken = null;
        this.tokens.add(accessor);
    }

    public void generateAccessToken(OAuthAccessor accessor) throws OAuthProblemException {
        String requestToken = accessor.requestToken;
        String secretToken = accessor.tokenSecret;
        Iterator<OAuthAccessor> iter = this.tokens.iterator();
        boolean valid = false;
        while (iter.hasNext()) {
            OAuthAccessor a = iter.next();
            if (a.requestToken == null || !a.requestToken.equals(requestToken) || a.tokenSecret == null || !a.tokenSecret.equals(secretToken)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Validation ok, for user '" + a.getProperty("userId") + "' access token will be generated."));
            }
            iter.remove();
            valid = true;
            break;
        }
        if (!valid) {
            throw new OAuthProblemException("Request token or secret token is invalid.");
        }
        accessor.accessToken = this.generateToken();
        accessor.tokenSecret = this.generateSecret();
        accessor.requestToken = null;
    }

    protected abstract String generateToken();

    protected abstract String generateSecret();
}

