/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.ws.security.oauth.OAuthProviderService;

public class OAuthProviderServiceImpl
implements OAuthProviderService {
    private final HashMap<String, OAuthConsumer> consumers = new HashMap();
    private final Map<String, OAuthAccessor> tokens = new ConcurrentHashMap<String, OAuthAccessor>();
    private static final Log LOG = ExoLogger.getLogger((String)OAuthProviderServiceImpl.class.getName());

    public OAuthProviderServiceImpl(InitParams params) {
        Iterator iterator = params.getPropertiesParamIterator();
        while (iterator.hasNext()) {
            PropertiesParam pp = (PropertiesParam)iterator.next();
            String name = pp.getName();
            String secret = pp.getProperty("consumer.secret");
            String description = pp.getProperty("consumer.secret");
            String callbackURL = pp.getProperty("consumer.callbackURL");
            OAuthConsumer consumer = new OAuthConsumer(callbackURL, name, secret, null);
            consumer.setProperty("consumer.name", (Object)name);
            consumer.setProperty("consumer.description", (Object)description);
            this.consumers.put(name, consumer);
        }
    }

    public OAuthConsumer getConsumer(String name) throws OAuthProblemException {
        OAuthConsumer consumer = this.consumers.get(name);
        if (consumer != null) {
            return consumer;
        }
        throw new OAuthProblemException("There is no appropriate consumer for " + name);
    }

    public OAuthAccessor getAccessor(OAuthMessage oauthMessage) throws OAuthProblemException {
        try {
            String token = oauthMessage.getParameter("oauth_token");
            String secret = oauthMessage.getParameter("oauth_token_secret");
            return this.getAccessor(token, secret);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OAuthProblemException(e.getMessage());
        }
    }

    public OAuthConsumer getConsumer(OAuthMessage oauthMessage) throws OAuthProblemException {
        String name = null;
        try {
            oauthMessage.requireParameters(new String[]{"oauth_consumer_key"});
            name = oauthMessage.getConsumerKey();
            return this.getConsumer(name);
        }
        catch (IOException e) {
            throw new OAuthProblemException("There is no appropriate consumer for " + name + ", or " + "oauth_consumer_key" + " is not presents in oauth message.");
        }
    }

    public void authorize(OAuthAccessor accessor, Identity identity) throws OAuthProblemException {
        if (identity == null) {
            throw new OAuthProblemException("Identity is null!");
        }
        this.tokens.remove(accessor.requestToken);
        accessor.setProperty("oauth_user_id", (Object)identity.getUserId());
        accessor.setProperty("oauth_user_roles", (Object)identity.getRoles());
        accessor.setProperty("authorized", (Object)Boolean.TRUE);
        this.tokens.put(accessor.requestToken, accessor);
    }

    public void generateRequestToken(OAuthAccessor accessor) {
        accessor.requestToken = this.generateToken();
        accessor.tokenSecret = this.generateSecret(accessor.requestToken);
        accessor.accessToken = null;
        this.tokens.put(accessor.requestToken, accessor);
    }

    public void generateAccessToken(OAuthAccessor accessor) throws OAuthProblemException {
        String token = accessor.requestToken;
        String secret = accessor.tokenSecret;
        if (this.getAccessor(token, secret) != null) {
            this.tokens.remove(token);
            accessor.accessToken = this.generateToken();
            accessor.tokenSecret = this.generateSecret(accessor.accessToken);
            accessor.requestToken = null;
        }
    }

    protected String generateToken() {
        return UUID.randomUUID().toString();
    }

    protected String generateSecret(String token) {
        return UUID.nameUUIDFromBytes(token.getBytes()).toString();
    }

    private OAuthAccessor getAccessor(String token, String secret) throws OAuthProblemException {
        OAuthAccessor accessor = this.tokens.get(token);
        if (accessor != null && accessor.tokenSecret != null && secret != null && secret.equals(accessor.tokenSecret)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request token found: " + token));
            }
            return accessor;
        }
        throw new OAuthProblemException("Request token or secret token is invalid.");
    }
}

