/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.sso.tomcat;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.realm.GenericPrincipal;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.sso.http.SSOAuthenticationFilter;

public class ExoSSOAuthenticatorValve
extends AuthenticatorBase {
    private String portalContainerName;

    public String getPortalContainerName() {
        return this.portalContainerName;
    }

    public void setPortalContainerName(String portalContainerName) {
        this.portalContainerName = portalContainerName;
    }

    protected ExoContainer getExoContainer() {
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        if (exoContainer instanceof RootContainer) {
            exoContainer = RootContainer.getInstance().getPortalContainer(this.getPortalContainerName());
        }
        return exoContainer;
    }

    protected boolean authenticate(Request request, Response response, LoginConfig loginConfig) throws IOException {
        Request httpRequest = request;
        Response httpResponse = response;
        Principal principal = SSOAuthenticationFilter.authenticate((HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
        if (principal != null) {
            String username = principal.getName();
            IdentityRegistry identityRegistry = (IdentityRegistry)this.getExoContainer().getComponentInstanceOfType(IdentityRegistry.class);
            Identity identity = identityRegistry.getIdentity(username);
            if (identity == null) {
                Authenticator authenticator = (Authenticator)this.getExoContainer().getComponentInstanceOfType(Authenticator.class);
                if (authenticator == null) {
                    throw new RuntimeException("No Authenticator component found, check your configuration");
                }
                try {
                    identity = authenticator.createIdentity(username);
                }
                catch (Exception e) {
                    return false;
                }
                identityRegistry.register(identity);
            }
            ArrayList roles = new ArrayList();
            Iterator iter = identity.getRoles().iterator();
            while (iter.hasNext()) {
                roles.add(iter.next());
            }
            GenericPrincipal serverPrincipal = new GenericPrincipal(null, username, "N/P", roles);
            this.register(request, response, (Principal)serverPrincipal, "", username, "N/P");
            return true;
        }
        return false;
    }
}

