/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ws.impl.cxf;

import java.util.List;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.ws.AbstractMultiWebService;
import org.exoplatform.services.ws.AbstractSingletonWebService;
import org.exoplatform.services.ws.impl.cxf.CXFUtils;
import org.picocontainer.Startable;

public class WebServiceLoader
implements Startable {
    private ExoContainer container;
    private List<AbstractSingletonWebService> singleservices;
    private List<AbstractMultiWebService> multiservices;
    private static final Log LOG = ExoLogger.getLogger(WebServiceLoader.class);

    public WebServiceLoader(ExoContainerContext containerContext) {
        this.container = containerContext.getContainer();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WebServiceLoader.WebServiceLoader() container = " + this.container));
        }
    }

    public void init() {
        String address;
        this.singleservices = this.container.getComponentInstancesOfType(AbstractSingletonWebService.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WebServiceLoader.init() singleservices = " + this.singleservices));
        }
        for (AbstractSingletonWebService abstractSingletonWebService : this.singleservices) {
            address = "/" + abstractSingletonWebService.getClass().getAnnotation(WebService.class).serviceName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("loadBus() - single address = " + address));
                LOG.debug((Object)("loadBus() - single implementor = " + abstractSingletonWebService));
            }
            CXFUtils.simpleDeployService(address, abstractSingletonWebService);
            LOG.info((Object)("New singleton WebService '" + address + "' registered."));
        }
        this.multiservices = this.container.getComponentInstancesOfType(AbstractMultiWebService.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WebServiceLoader.init() multiservices = " + this.multiservices));
        }
        for (AbstractMultiWebService abstractMultiWebService : this.multiservices) {
            address = "/" + abstractMultiWebService.getClass().getAnnotation(WebService.class).serviceName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("loadBus() - multi address = " + address));
                LOG.debug((Object)("loadBus() - multi implementor = " + abstractMultiWebService));
            }
            CXFUtils.complexDeployServiceMultiInstance(address, abstractMultiWebService, null);
            LOG.info((Object)("New multi-instance WebService '" + address + "' registered."));
        }
    }

    public void start() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"WebServiceLoader.start() entering.");
        }
    }

    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"WebServiceLoader.stop() entering.");
        }
    }
}

