/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ws.impl.xfire;

import java.util.List;
import org.apache.commons.logging.Log;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.annotations.AnnotationServiceFactory;
import org.codehaus.xfire.picocontainer.util.PicoFactory;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.service.invoker.FactoryInvoker;
import org.codehaus.xfire.service.invoker.Invoker;
import org.codehaus.xfire.service.invoker.RequestScopePolicy;
import org.codehaus.xfire.util.factory.Factory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.ws.AbstractWebService;
import org.picocontainer.Startable;
import org.picocontainer.defaults.ObjectReference;
import org.picocontainer.defaults.SimpleReference;

public class WebServiceLoader
implements Startable {
    private ExoContainer container;
    private XFire xfire;
    private AnnotationServiceFactory serviceFactory;
    private List<AbstractWebService> services;
    private static final Log LOG = ExoLogger.getLogger(WebServiceLoader.class);

    public WebServiceLoader(ExoContainerContext containerContext) {
        this.container = containerContext.getContainer();
        this.createXFire();
        this.createFactory();
    }

    private void createXFire() {
        if (this.xfire == null) {
            this.xfire = XFireFactory.newInstance().getXFire();
        }
    }

    private void createFactory() {
        if (this.serviceFactory == null) {
            this.serviceFactory = new AnnotationServiceFactory();
        }
    }

    private ServiceRegistry getRegistry() {
        return this.xfire.getServiceRegistry();
    }

    public void start() {
        this.services = this.container.getComponentInstancesOfType(AbstractWebService.class);
        for (AbstractWebService as : this.services) {
            Service ws = this.serviceFactory.create(as.getClass());
            SimpleReference simpleReference = new SimpleReference();
            simpleReference.set((Object)this.container);
            ws.setInvoker((Invoker)new FactoryInvoker((Factory)new PicoFactory((ObjectReference)simpleReference, (Object)ws.getServiceInfo().getServiceClass()), RequestScopePolicy.instance()));
            this.getRegistry().register(ws);
            LOG.info((Object)("New WebService " + ws.getName() + " registered."));
        }
    }

    public void stop() {
    }
}

