/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ws.impl.xfire.transport.http;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.http.XFireServletController;
import org.exoplatform.services.log.ExoLogger;

public class XFireServlet
extends HttpServlet {
    private static final long serialVersionUID = -5378038765850618608L;
    public static final String XFIRE_INSTANCE = "xfire.instance";
    protected XFire xfire;
    protected XFireServletController controller;
    private static final Log LOG = ExoLogger.getLogger((String)"ws.soap.XFireServlet");

    public void init() throws ServletException {
        try {
            super.init();
            this.xfire = this.createXFire();
            this.controller = this.createController();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)this.xfire);
                LOG.debug((Object)this.controller);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error initializing XFireServlet.", (Throwable)e);
            throw new ServletException("Error initializing XFireServlet.", (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"doGet called");
        }
        this.controller.doService(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"doPost called");
        }
        this.controller.doService(req, res);
    }

    public void destroy() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Destroying Servlet");
        }
        for (Transport transport : this.xfire.getTransportManager().getTransports()) {
            transport.dispose();
        }
        super.destroy();
    }

    private XFire createXFire() throws ServletException {
        try {
            if (this.getServletContext().getAttribute(XFIRE_INSTANCE) != null) {
                return (XFire)this.getServletContext().getAttribute(XFIRE_INSTANCE);
            }
            XFireFactory factory = XFireFactory.newInstance();
            return factory.getXFire();
        }
        catch (Exception e) {
            throw new ServletException("Couldn't start XFire.", (Throwable)e);
        }
    }

    private XFireServletController createController() {
        return new XFireServletController(this.xfire, this.getServletContext());
    }
}

