/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.test.mock;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockServletContext
implements ServletContext {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.testframework.MockServletContext");
    private String name;
    private HashMap<String, String> initParams;
    private HashMap<String, Object> attributes;
    private String contextPath;
    private StringBuffer logBuffer = new StringBuffer();

    public MockServletContext() {
        this("MockServletContext1");
    }

    public MockServletContext(String name) {
        this(name, "/" + name);
    }

    public MockServletContext(String name, String path) {
        this.name = name;
        this.contextPath = path;
        this.initParams = new HashMap();
        this.attributes = new HashMap();
        this.attributes.put("javax.servlet.context.tempdir", path);
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogBuffer() {
        try {
            String string = this.logBuffer.toString();
            return string;
        }
        finally {
            this.logBuffer = new StringBuffer();
        }
    }

    public ServletContext getContext(String s) {
        return null;
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 0;
    }

    public String getMimeType(String s) {
        return "text/html";
    }

    public Set getResourcePaths(String s) {
        HashSet<String> set;
        block6: {
            if (!s.endsWith("/")) {
                s = s + "/";
            }
            set = new HashSet<String>();
            set.add("/WEB-INF/");
            try {
                URL url = this.getResource(s);
                File dir = new File(url.getPath());
                if (dir.isDirectory()) {
                    File[] arr = dir.listFiles();
                    for (int i = 0; i < arr.length; ++i) {
                        File tmp = arr[i];
                        if (tmp.isDirectory()) {
                            set.add(s + "/" + tmp.getName() + "/");
                            continue;
                        }
                        set.add(s + "/" + tmp.getName());
                    }
                }
            }
            catch (MalformedURLException e) {
                if (!LOG.isTraceEnabled()) break block6;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
        return set;
    }

    public URL getResource(String s) throws MalformedURLException {
        String path = "file:" + this.contextPath + s;
        URL url = new URL(path);
        return url;
    }

    public InputStream getResourceAsStream(String s) {
        try {
            return this.getResource(s).openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String s) {
        return null;
    }

    @Deprecated
    public Servlet getServlet(String s) throws ServletException {
        return null;
    }

    @Deprecated
    public Enumeration getServlets() {
        return null;
    }

    @Deprecated
    public Enumeration getServletNames() {
        return null;
    }

    public void log(String s) {
        this.logBuffer.append(s);
    }

    @Deprecated
    public void log(Exception e, String s) {
        this.logBuffer.append(s + e.getMessage());
    }

    public void log(String s, Throwable throwable) {
        this.logBuffer.append(s + throwable.getMessage());
    }

    public void setContextPath(String s) {
        this.contextPath = s;
    }

    public String getRealPath(String s) {
        return this.contextPath + s;
    }

    public String getServerInfo() {
        return null;
    }

    public boolean setInitParameter(String name, String value) {
        this.initParams.put(name, value);
        return true;
    }

    public String getInitParameter(String name) {
        return this.initParams.get(name);
    }

    public Enumeration getInitParameterNames() {
        Vector<String> keys = new Vector<String>(this.initParams.keySet());
        return keys.elements();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        Vector<String> keys = new Vector<String>(this.attributes.keySet());
        return keys.elements();
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getServletContextName() {
        return this.name;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public int getEffectiveMajorVersion() {
        return 3;
    }

    public int getEffectiveMinorVersion() {
        return 0;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return null;
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        return null;
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return null;
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return null;
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        return null;
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return null;
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return null;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return null;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    public void addListener(String className) {
    }

    public <T extends EventListener> void addListener(T t) {
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        return null;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public void declareRoles(String ... roleNames) {
    }
}

