/*
 * This file is part of the Meeds project (https://meeds.io/).
 * Copyright (C) 2020 Meeds Association
 * contact@meeds.io
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package org.exoplatform.ws.frameworks.json;


/**
 * @author <a href="mailto:andrew00x@gmail.com">Andrey Parfonov</a>
 * @version $Id$
 */
public enum BookEnum {

   JUNIT_IN_ACTION(new Book("Vincent Masson", "JUnit in Action", 19.37, 93011099534534L, 386, true, false)), //
   BEGINNING_C(new Book("Christian Gross", "Beginning C# 2008 from novice to professional", 23.56, 9781590598696L, 511,
      false, false));

   private final Book book;

   private BookEnum(Book book)
   {
      this.book = book;
   }

   @Override
   public String toString()
   {
      return book.toString();
   }
}
