/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.cobbler;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fedorahosted.cobbler.CobblerConnection;
import org.fedorahosted.cobbler.Finder;
import org.fedorahosted.cobbler.ObjectType;
import org.fedorahosted.cobbler.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CobblerObject {
    protected String handle;
    protected Map dataMap = new HashMap();
    protected Map blendedDataMap = new HashMap();
    protected CobblerConnection client;
    static final String NAME = "name";
    static final String UID = "uid";
    protected Boolean newObject = false;

    public CobblerObject(CobblerConnection clientIn, Map dataMapIn, Map blendedDataMapIn) {
        this.client = clientIn;
        this.dataMap = dataMapIn;
        this.blendedDataMap = blendedDataMapIn;
        if (this.dataMap.keySet().size() == 0) {
            this.newObject = true;
        }
    }

    public abstract String getName();

    protected abstract ObjectType getObjectType();

    protected static List lookupDataMapsByCriteria(CobblerConnection client, String critera, String value, String findMethod) {
        return null;
    }

    private void refreshObjectState() {
        CobblerObject lookupCopy = Finder.getInstance().findItemByName(this.client, this.getObjectType(), this.getName());
        if (lookupCopy == null) {
            throw new XmlRpcException("Unable to refresh object state: " + this.getName());
        }
        this.dataMap = lookupCopy.dataMap;
        this.blendedDataMap = lookupCopy.blendedDataMap;
    }

    protected void modify(String key, Object value) {
        this.dataMap.put(key, value);
    }

    protected void modify(String key, Object value, String interfaceName) {
        HashMap interfaces = (HashMap)this.dataMap.get("interfaces");
        HashMap theInterface = (HashMap)interfaces.get(key);
        String theName = (String)interfaces.get(interfaceName);
        theInterface.put(key, value);
    }

    protected Object access(String key) {
        return this.dataMap.get(key);
    }

    protected Object blendedAccess(String key) {
        return this.blendedDataMap.get(key);
    }

    protected Object access(String key, String interfaceName) {
        HashMap interfaces = (HashMap)this.dataMap.get("interfaces");
        HashMap theInterface = (HashMap)interfaces.get(interfaceName);
        return theInterface.get(key);
    }

    public String toString() {
        return (Object)((Object)this.getObjectType()) + "\n" + this.dataMap.toString();
    }

    public void commit() {
        if (this.newObject.booleanValue()) {
            this.client.invokeMethod("xapi_object_edit", this.getObjectType().getName(), this.getName(), "add", this.dataMap);
            this.newObject = false;
            this.refreshObjectState();
        } else {
            this.client.invokeMethod("xapi_object_edit", this.getObjectType().getName(), this.getName(), "edit", this.dataMap);
        }
    }

    public void remove() {
        this.client.invokeMethod("xapi_object_edit", this.getObjectType().getName(), this.getName(), "remove", this.dataMap);
    }

    protected String getHandle() {
        if (this.handle == null || this.handle.trim().length() == 0) {
            this.handle = this.invokeGetHandle();
        }
        return this.handle;
    }

    private String invokeGetHandle() {
        return (String)this.client.invokeMethod("get_" + this.getObjectType().getName() + "_handle", this.getName());
    }

    static CobblerObject load(ObjectType type, CobblerConnection client, Map<String, Object> dataMap, Map<String, Object> blendedDataMap) {
        try {
            Constructor ctor = type.getObjectClass().getConstructor(CobblerConnection.class, Map.class, Map.class);
            CobblerObject obj = (CobblerObject)ctor.newInstance(client, dataMap, blendedDataMap);
            return obj;
        }
        catch (Exception e) {
            throw new XmlRpcException("Class instantiation exception.", e);
        }
    }
}

