/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit;

import java.io.Serializable;
import org.ff4j.audit.EventType;

public class Event
implements Serializable {
    private static final long serialVersionUID = 6490780530212257217L;
    private EventType type;
    private String featureName;
    private long timestamp = System.currentTimeMillis();

    public Event() {
    }

    public Event(String featureName, EventType type) {
        this();
        this.featureName = featureName;
        this.type = type;
    }

    public Event(String featureName, EventType type, long time) {
        this(featureName, type);
        this.timestamp = time;
    }

    public EventType getType() {
        return this.type;
    }

    public void setType(EventType type) {
        this.type = type;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.toJson();
    }

    public String toCSV() {
        return this.timestamp + ";" + this.featureName + ";" + (Object)((Object)this.type);
    }

    public String toThreadName() {
        return this.timestamp + "-" + this.featureName + "-" + (Object)((Object)this.type);
    }

    public String toJson() {
        return "{\"type\": \"" + (Object)((Object)this.type) + "\", \"featureName\":\"" + this.featureName + "\", \"timestamp\":" + this.timestamp + "}";
    }
}

