/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit.graph;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ff4j.audit.graph.AbstractGraphFF4j;
import org.ff4j.audit.graph.BarSeries;
import org.ff4j.utils.Util;

public class BarChart
extends AbstractGraphFF4j {
    private static final long serialVersionUID = -7438492625518407540L;
    private Map<String, BarSeries> series = new LinkedHashMap<String, BarSeries>();
    private List<String> labels = new ArrayList<String>();

    public BarChart() {
    }

    public BarChart(String title, List<String> labels, List<String> seriesName) {
        this.labels = labels;
        this.setTitle(title);
        List<String> colors = Util.getColorsGradient(seriesName.size());
        for (int idx = 0; idx < seriesName.size(); ++idx) {
            this.series.put(seriesName.get(idx), new BarSeries(seriesName.get(idx), colors.get(idx), labels.size()));
        }
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder("{");
        sb.append(" \"title\" : \"" + this.getTitle() + "\", ");
        sb.append(" \"series\" : [");
        boolean first = true;
        for (String bs : this.series.keySet()) {
            if (!first) {
                sb.append(",");
            }
            sb.append(this.series.get(bs).toString());
            first = false;
        }
        sb.append("],");
        sb.append(" \"labels\" : [");
        first = true;
        for (String label : this.labels) {
            if (!first) {
                sb.append(",");
            }
            sb.append(" \"" + label + "\"");
            first = false;
        }
        sb.append("] }");
        return sb.toString();
    }

    public String toString() {
        return this.toJson();
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public Map<String, BarSeries> getSeries() {
        return this.series;
    }

    public void setSeries(Map<String, BarSeries> series) {
        this.series = series;
    }
}

