/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BarSeries
implements Serializable {
    private static final long serialVersionUID = -8669264222408815943L;
    private String label = "N/A";
    private String color = "FFFFFF";
    private List<Double> values = new ArrayList<Double>();

    public BarSeries(String label, String color, int nbValue) {
        this.label = label;
        this.color = color;
        for (int idx = 0; idx < nbValue; ++idx) {
            this.values.add(new Double(0.0));
        }
    }

    public String toString() {
        return this.toJson();
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder("{");
        sb.append(" \"label\" : \"" + this.getLabel() + "\", ");
        sb.append(" \"color\" : \"" + this.getColor() + "\", ");
        sb.append(" \"values\" : [");
        boolean first = true;
        for (Double val : this.values) {
            if (!first) {
                sb.append(",");
            }
            sb.append(val);
            first = false;
        }
        sb.append("] }");
        return sb.toString();
    }

    public void incrCount(int offset) {
        this.getValues().set(offset, this.getValues().get(offset) + 1.0);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public List<Double> getValues() {
        return this.values;
    }

    public void setValues(List<Double> values) {
        this.values = values;
    }
}

