/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cache;

import java.util.Map;
import java.util.Set;
import org.ff4j.cache.FeatureCacheManager;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;

public class FeatureStoreCacheProxy
implements FeatureStore {
    private FeatureStore target;
    private FeatureCacheManager cacheManager;

    public FeatureStoreCacheProxy() {
    }

    public FeatureStoreCacheProxy(FeatureStore store, FeatureCacheManager cache) {
        this.target = store;
        this.cacheManager = cache;
    }

    @Override
    public void enable(String featureId) {
        this.getTarget().enable(featureId);
        this.getCacheManager().evict(featureId);
    }

    @Override
    public void disable(String featureId) {
        this.getTarget().disable(featureId);
        this.getCacheManager().evict(featureId);
    }

    @Override
    public boolean exist(String featureId) {
        if (this.getCacheManager().get(featureId) == null) {
            return this.getTarget().exist(featureId);
        }
        return true;
    }

    @Override
    public void create(Feature fp) {
        this.getTarget().create(fp);
        this.getCacheManager().put(fp);
        this.getCacheManager().evict(fp.getUid());
    }

    @Override
    public Feature read(String featureUid) {
        Feature fp = this.getCacheManager().get(featureUid);
        if (null == fp) {
            fp = this.getTarget().read(featureUid);
            this.getCacheManager().put(fp);
        }
        return fp;
    }

    @Override
    public Map<String, Feature> readAll() {
        return this.getTarget().readAll();
    }

    @Override
    public Set<String> readAllGroups() {
        return this.getTarget().readAllGroups();
    }

    @Override
    public void delete(String featureId) {
        this.getTarget().delete(featureId);
        this.getCacheManager().evict(featureId);
    }

    @Override
    public void update(Feature fp) {
        this.getTarget().update(fp);
        this.getCacheManager().evict(fp.getUid());
    }

    @Override
    public void grantRoleOnFeature(String featureId, String roleName) {
        this.getTarget().grantRoleOnFeature(featureId, roleName);
        this.getCacheManager().evict(featureId);
    }

    @Override
    public void removeRoleFromFeature(String featureId, String roleName) {
        this.getTarget().removeRoleFromFeature(featureId, roleName);
        this.getCacheManager().evict(featureId);
    }

    @Override
    public void enableGroup(String groupName) {
        this.getTarget().enableGroup(groupName);
        this.getCacheManager().clear();
    }

    @Override
    public void disableGroup(String groupName) {
        this.getTarget().disableGroup(groupName);
        this.getCacheManager().clear();
    }

    @Override
    public boolean existGroup(String groupName) {
        return this.getTarget().existGroup(groupName);
    }

    @Override
    public Map<String, Feature> readGroup(String groupName) {
        return this.getTarget().readGroup(groupName);
    }

    @Override
    public void addToGroup(String featureId, String groupName) {
        this.getTarget().addToGroup(featureId, groupName);
        this.getCacheManager().evict(featureId);
    }

    @Override
    public void removeFromGroup(String featureId, String groupName) {
        this.getTarget().removeFromGroup(featureId, groupName);
        this.getCacheManager().evict(featureId);
    }

    public FeatureStore getTarget() {
        if (this.target == null) {
            throw new IllegalArgumentException("ff4j-core: Target for cache proxy has not been provided");
        }
        return this.target;
    }

    public void setTarget(FeatureStore target) {
        this.target = target;
    }

    public FeatureCacheManager getCacheManager() {
        if (this.cacheManager == null) {
            throw new IllegalArgumentException("ff4j-core: CacheManager for cache proxy has not been provided but it's required");
        }
        return this.cacheManager;
    }

    public void setCacheManager(FeatureCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public String getCacheProvider() {
        return this.cacheManager.getCacheProviderName();
    }

    @Override
    public String getCachedTargetStore() {
        return this.target.getClass().getCanonicalName();
    }
}

