/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cache;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.ff4j.cache.FeatureCacheManager;
import org.ff4j.cache.InMemoryCacheEntry;
import org.ff4j.core.Feature;

public class InMemoryCacheManager
implements FeatureCacheManager {
    public static final long DEFAULT_TTL = 3600L;
    public static final long TO_MILLIS = 1000L;
    public static final String DEFAULT_CACHENAME = "ff4j-cache";
    private final Map<String, InMemoryCacheEntry<Feature>> cache = new WeakHashMap<String, InMemoryCacheEntry<Feature>>();
    private long ttl = 3600L;

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void evict(String featureId) {
        if (this.cache.containsKey(featureId)) {
            this.cache.remove(featureId);
        }
    }

    @Override
    public void put(Feature feat) {
        if (feat == null) {
            throw new IllegalArgumentException("ff4j-core: Cannot insert null feature into cache");
        }
        if (feat.getUid() == null || feat.getUid().isEmpty()) {
            throw new IllegalArgumentException("ff4j-core: Cannot insert feature with null identifier into cache");
        }
        this.cache.put(feat.getUid(), new InMemoryCacheEntry<Feature>(feat));
    }

    @Override
    public Feature get(String featureId) {
        InMemoryCacheEntry<Feature> ice = this.cache.get(featureId);
        if (ice != null) {
            if (System.currentTimeMillis() - ice.getInsertedDate() >= 1000L * this.ttl) {
                this.evict(featureId);
            } else {
                return ice.getEntry();
            }
        }
        return null;
    }

    @Override
    public String getCacheProviderName() {
        return "In-Memory";
    }

    @Override
    public Set<String> listCachedFeatureNames() {
        return this.cache.keySet();
    }

    @Override
    public Object getNativeCache() {
        return this.cache;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }
}

