/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.core;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.exception.PropertyNotFoundException;
import org.ff4j.property.AbstractProperty;
import org.ff4j.utils.JsonUtils;
import org.ff4j.utils.Util;

public class Feature
implements Serializable {
    private static final long serialVersionUID = -1345806526991179050L;
    private String uid;
    private boolean enable = false;
    private String description;
    private String group;
    private Set<String> permissions = new TreeSet<String>();
    private FlippingStrategy flippingStrategy;
    private Map<String, AbstractProperty<?>> customProperties = new LinkedHashMap();

    public Feature(String uid) {
        this(uid, false, null);
    }

    public Feature(String uid, boolean penable) {
        this(uid, penable, null);
    }

    public Feature(String uid, boolean penable, String pdescription) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
        }
        this.uid = uid;
        this.enable = penable;
        this.description = pdescription;
    }

    public Feature(String uid, boolean penable, String pdescription, String group) {
        this(uid, penable, pdescription);
        if (group != null && !"".equals(group)) {
            this.group = group;
        }
    }

    public Feature(String uid, boolean penable, String pdescription, String group, Collection<String> auths) {
        this(uid, penable, pdescription, group);
        if (auths != null && !auths.isEmpty()) {
            this.permissions = new HashSet<String>(auths);
        }
    }

    public Feature(String uid, boolean penable, String pdescription, String group, Collection<String> auths, FlippingStrategy strat) {
        this(uid, penable, pdescription, group, auths);
        if (strat != null) {
            this.flippingStrategy = strat;
        }
    }

    public String toString() {
        return this.toJson();
    }

    public String toJson() {
        StringBuilder json = new StringBuilder("{");
        json.append("\"uid\":\"" + this.uid + "\"");
        json.append(",\"enable\":" + this.enable);
        json.append(",\"description\":");
        json.append(null == this.description ? "null" : "\"" + this.description + "\"");
        json.append(",\"group\":");
        json.append(null == this.group ? "null" : "\"" + this.group + "\"");
        json.append(",\"permissions\":" + JsonUtils.permissionsAsJson(this.permissions));
        json.append(",\"flippingStrategy\":" + JsonUtils.flippingStrategyAsJson(this.flippingStrategy));
        json.append(",\"customProperties\":" + JsonUtils.customPropertiesAsJson(this.customProperties));
        json.append("}");
        return json.toString();
    }

    public void enable() {
        this.enable = true;
    }

    public void disable() {
        this.enable = false;
    }

    public void toggle() {
        this.enable = !this.enable;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FlippingStrategy getFlippingStrategy() {
        return this.flippingStrategy;
    }

    public void setFlippingStrategy(FlippingStrategy flippingStrategy) {
        this.flippingStrategy = flippingStrategy;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public <T> AbstractProperty<T> getProperty(String propId) {
        Util.assertNotNull(propId);
        if (this.customProperties != null && this.customProperties.containsKey(propId)) {
            return this.customProperties.get(propId);
        }
        throw new PropertyNotFoundException(propId);
    }

    public Map<String, AbstractProperty<?>> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, AbstractProperty<?>> customProperties) {
        this.customProperties = customProperties;
    }
}

